/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import cn.smarthse.radiationTraining.modules.sys.converter.sys.FileConverter;
import cn.smarthse.radiationTraining.modules.sys.dao.sys.SysFileMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysFile;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysFileService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysFileServiceImpl
extends ServiceImpl<SysFileMapper, SysFile>
implements ISysFileService {
    private final OssClientBean ossClientBean;
    private final FileConverter fileConverter;

    @Override
    public SysFile getByHash(String filehash) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysFile::getFileHash, (Object)filehash)).eq(BaseBean::getIsValid, (Object)Constant.TRUE)).last("limit 1");
        return (SysFile)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<SysFile> getFileById(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return null;
        }
        List idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        return this.listByIds(idList);
    }

    @Override
    public List<SysFile> getFileByUrl(String url) {
        return null;
    }

    @Override
    public List<SysFileVo> getFileVoByIds(String files) {
        List<SysFile> list = this.getFileById(files);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        list.forEach(record -> record.setFullOssUrl(this.ossClientBean.getUrl(record.getOssUrl())));
        return this.fileConverter.file2FileVo(list);
    }

    @Generated
    public SysFileServiceImpl(OssClientBean ossClientBean, FileConverter fileConverter) {
        this.ossClientBean = ossClientBean;
        this.fileConverter = fileConverter;
    }
}

