/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.modules.sys.converter.AreaDtoMap;
import cn.smarthse.radiationTraining.modules.sys.dao.sys.SysAreaMapper;
import cn.smarthse.radiationTraining.modules.sys.dto.AreaDto;
import cn.smarthse.radiationTraining.modules.sys.dto.sys.SysAreaTreeDto;
import cn.smarthse.radiationTraining.modules.sys.entity.SysArea;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysAreaService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SysAreaServiceImpl
extends ServiceImpl<SysAreaMapper, SysArea>
implements ISysAreaService {
    private final AreaDtoMap areaDtoMap;

    @Override
    @Cacheable(value={"area=24"}, key="#areaId", unless="#result == null", condition="#areaId != null")
    public AreaDto getAreaById(Long areaId) {
        return this.areaDtoMap.area2areaDto((SysArea)this.getById(areaId));
    }

    @Override
    public String getAreaNameById(Long areaId) {
        SysArea area = (SysArea)this.getById(areaId);
        return area != null ? area.getName() : null;
    }

    @Override
    public List<AreaDto> getAreaList(Long pid) {
        pid = pid == null ? 0L : pid;
        QueryWrapper queryWrapper = ((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"pid", (Object)pid)).eq((Object)"is_valid", (Object)Constant.YES)).select(new String[]{"id", "pid", "name", "level", "province_id", "province_name", "city_id", "city_name", "area_id", "area_name", "street_id", "street_name"});
        List list = this.list((Wrapper)queryWrapper);
        return this.areaDtoMap.area2areaDto(list);
    }

    @Override
    public List<SysAreaTreeDto> getAreaTreeList(Long pid) {
        if (pid == null) {
            pid = 0L;
            SysArea sysArea = (SysArea)this.getById(pid);
            SysAreaTreeDto sysAreaTreeDto = new SysAreaTreeDto();
            sysAreaTreeDto.setId(sysArea.getId());
            sysAreaTreeDto.setName(sysArea.getName());
            sysAreaTreeDto.setIsParent(Boolean.valueOf(sysArea.getLevel() != 4));
            sysAreaTreeDto.setParentId(sysArea.getPid());
            sysAreaTreeDto.setAreaLevel(sysArea.getLevel());
            return Collections.singletonList(sysAreaTreeDto);
        }
        return ((SysAreaMapper)this.baseMapper).getAreaTreeList(pid);
    }

    @Override
    public String getAreaAddress(Long areaId, String linkCode) {
        if (areaId == null) {
            return "";
        }
        SysArea sysArea = (SysArea)this.getById(areaId);
        if (sysArea == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (sysArea.getLevel() >= 1) {
            result.append(sysArea.getProvinceName());
        }
        if (sysArea.getLevel() >= 2) {
            result.append(linkCode).append(sysArea.getCityName());
        }
        if (sysArea.getLevel() >= 3) {
            result.append(linkCode).append(sysArea.getAreaName());
        }
        if (sysArea.getLevel() >= 4) {
            result.append(linkCode).append(sysArea.getStreetName());
        }
        return result.toString();
    }

    @Override
    public String getAreaAddress(Long areaId) {
        return this.getAreaAddress(areaId, ">");
    }

    @Override
    public Map<String, Long> getByAreaAddress(List<String> areaAddressList) {
        HashMap<String, Long> map = new HashMap<String, Long>(areaAddressList.size());
        areaAddressList.forEach(record -> map.put((String)record, this.getByAreaAddress((String)record)));
        return map;
    }

    @Override
    public Long getByAreaAddress(String areaAddress) {
        String[] split = areaAddress.split(">");
        int length = split.length;
        SysArea area = null;
        if (length == 1) {
            area = this.getAreaByName(split[0]);
        }
        if (length == 2) {
            area = this.getAreaByName(split[0], split[1]);
        }
        if (length == 3) {
            area = this.getAreaByName(split[0], split[1], split[2]);
        }
        if (length == 4) {
            area = this.getAreaByName(split[0], split[1], split[2], split[3]);
        }
        return area != null ? area.getId() : null;
    }

    @Override
    public Integer getLevel(Long areaId) {
        SysArea area = (SysArea)((SysAreaMapper)this.baseMapper).selectById(areaId);
        return area == null ? null : area.getLevel();
    }

    private SysArea getAreaByName(String provinceName) {
        QueryWrapper queryWrapper = ((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"province_name", (Object)provinceName)).eq((Object)"is_valid", (Object)Constant.YES)).select(new String[]{"id", "pid", "name", "level", "province_id", "province_name"});
        return (SysArea)this.getOne((Wrapper)queryWrapper);
    }

    private SysArea getAreaByName(String provinceName, String cityName) {
        QueryWrapper queryWrapper = ((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"province_name", (Object)provinceName)).eq((Object)"name", (Object)cityName)).eq((Object)"is_valid", (Object)Constant.YES)).select(new String[]{"id", "pid", "name", "level", "province_id", "province_name", "city_id", "city_name"});
        SysArea area = (SysArea)this.getOne((Wrapper)queryWrapper);
        return area != null ? area : this.getAreaByName(provinceName);
    }

    private SysArea getAreaByName(String provinceName, String cityName, String areaName) {
        QueryWrapper queryWrapper = ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"province_name", (Object)provinceName)).eq((Object)"city_name", (Object)cityName)).eq((Object)"name", (Object)areaName)).eq((Object)"is_valid", (Object)Constant.YES)).select(new String[]{"id", "pid", "name", "level", "province_id", "province_name", "city_id", "city_name", "area_id", "area_name"});
        SysArea area = (SysArea)this.getOne((Wrapper)queryWrapper);
        return area != null ? area : this.getAreaByName(provinceName, cityName);
    }

    private SysArea getAreaByName(String provinceName, String cityName, String areaName, String streetName) {
        QueryWrapper queryWrapper = ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"province_name", (Object)provinceName)).eq((Object)"city_name", (Object)cityName)).eq((Object)"area_name", (Object)areaName)).eq((Object)"name", (Object)streetName)).eq((Object)"is_valid", (Object)Constant.YES)).select(new String[]{"id", "pid", "name", "level", "province_id", "province_name", "city_id", "city_name", "area_id", "area_name", "street_id", "street_name"});
        SysArea area = (SysArea)this.getOne((Wrapper)queryWrapper);
        return area != null ? area : this.getAreaByName(provinceName, cityName, areaName);
    }

    @Generated
    public SysAreaServiceImpl(AreaDtoMap areaDtoMap) {
        this.areaDtoMap = areaDtoMap;
    }
}

