/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.sys.converter.sys.AppVersionConverter;
import cn.smarthse.radiationTraining.modules.sys.dao.sys.SysAppVersionMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysAppVersion;
import cn.smarthse.radiationTraining.modules.sys.param.sys.CheckAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.QueryAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysAppVersionService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CheckAppVersionVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysAppVersionVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SysAppVersionServiceImpl
extends ServiceImpl<SysAppVersionMapper, SysAppVersion>
implements ISysAppVersionService {
    @Autowired(required=false)
    private AppVersionConverter converter;
    @Autowired
    private ISysAppVersionService self;

    @Override
    public LayuiGridData<SysAppVersionVo> search(QueryAppVersionParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SysAppVersionVo> voList = ((SysAppVersionMapper)this.baseMapper).search(param);
        return new LayuiGridData((Page)voList, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    @Caching(evict={@CacheEvict(value={"APP:VERSION"}, allEntries=true), @CacheEvict(value={"APP:VERSION:NEWEST"}, allEntries=true), @CacheEvict(value={"APP:VERSION:NEWEST_OF_FORCED"}, allEntries=true), @CacheEvict(value={"APP:VERSION:EVERY"}, key="#param.version+'_'+#param.type")})
    public void addOrUpVersion(SaveAppVersionParam param) {
        SysAppVersion upEntity = this.converter.upParamToEntity(param);
        if (!this.checkVersion(param.getId(), param.getVersion(), param.getType())) {
            throw new ServiceException("\u7248\u672c\u53f7\u51b2\u7a81");
        }
        if (upEntity.getId() == null) {
            upEntity.setCreateBy(param.getLoginUserId());
            upEntity.setCreateTime(new Date());
        } else {
            upEntity.setUpdateBy(param.getLoginUserId());
            upEntity.setUpdateTime(new Date());
        }
        this.saveOrUpdate(upEntity);
    }

    @Override
    @Transactional
    public void deleteVersion(Long id) {
        SysAppVersion sysAppVersion = (SysAppVersion)this.getById(id);
        if (sysAppVersion == null) {
            return;
        }
        this.self.deleteVersion(sysAppVersion.getVersion(), sysAppVersion.getType());
    }

    @Override
    @Transactional
    @Caching(evict={@CacheEvict(value={"APP:VERSION"}, allEntries=true), @CacheEvict(value={"APP:VERSION:NEWEST"}, allEntries=true), @CacheEvict(value={"APP:VERSION:NEWEST_OF_FORCED"}, allEntries=true), @CacheEvict(value={"APP:VERSION:EVERY"}, key="#version+'_'+#type")})
    public void deleteVersion(String version, Integer type) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(SysAppVersion::getVersion, (Object)version)).eq(SysAppVersion::getType, (Object)type);
        ((SysAppVersionMapper)this.baseMapper).delete((Wrapper)wrapper);
    }

    @Override
    public CheckAppVersionVo checkUserAppVersion(CheckAppVersionParam param) {
        SysAppVersionVo newestOfForcedupdatingVersion = this.self.getNewestOfForcedUpdatingVersion(param.getType());
        SysAppVersionVo newest = this.self.getNewest(param.getType());
        SysAppVersionVo currVersion = this.self.getCurrVersion(param.getVersion(), param.getType());
        if (currVersion == null) {
            throw new ServiceException("\u5f53\u524d\u7248\u672c\u9519\u8bef");
        }
        Integer compareForcedVersionResult = this.compareVersion(currVersion, newestOfForcedupdatingVersion);
        Integer compareNewestVersionResult = this.compareVersion(currVersion, newest);
        CheckAppVersionVo checkAppVersionVo = new CheckAppVersionVo();
        if (compareForcedVersionResult == 0) {
            checkAppVersionVo.setHasNewerForcedVersion(Integer.valueOf(1));
        } else {
            checkAppVersionVo.setHasNewerForcedVersion(Integer.valueOf(0));
        }
        if (compareNewestVersionResult == 0) {
            checkAppVersionVo.setHasNewerVersion(Integer.valueOf(1));
        } else {
            checkAppVersionVo.setHasNewerVersion(Integer.valueOf(0));
        }
        return checkAppVersionVo;
    }

    @Override
    @Cacheable(cacheNames={"APP:VERSION:EVERY"}, key="#version+'_'+#type", unless="#result == null")
    public SysAppVersionVo getCurrVersion(String version, Integer type) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(SysAppVersion::getVersion, (Object)version)).eq(SysAppVersion::getType, (Object)type);
        return this.converter.entityToVo((SysAppVersion)((SysAppVersionMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    @Override
    @Cacheable(cacheNames={"APP:VERSION:NEWEST_OF_FORCED"}, key="#type", unless="#result == null")
    public SysAppVersionVo getNewestOfForcedUpdatingVersion(Integer type) {
        return this.converter.entityToVo(((SysAppVersionMapper)this.baseMapper).getNewestOfForcedUpdatingVersion(type));
    }

    @Override
    @Cacheable(cacheNames={"APP:VERSION:NEWEST"}, key="#type", unless="#result == null")
    public SysAppVersionVo getNewest(Integer type) {
        return this.converter.entityToVo(((SysAppVersionMapper)this.baseMapper).getNewest(type));
    }

    public boolean checkVersion(Long id, String version, Integer type) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(SysAppVersion::getVersion, (Object)version)).eq(SysAppVersion::getType, (Object)type);
        SysAppVersion sysAppVersion = (SysAppVersion)((SysAppVersionMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        return id == null ? sysAppVersion == null : sysAppVersion == null || sysAppVersion.getId().equals(id);
    }

    public Integer compareVersion(SysAppVersionVo a, SysAppVersionVo b) {
        if (a == null) {
            throw new ServiceException("\u53c2\u65701\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (b == null) {
            return 1;
        }
        if (a.getVersionX() > b.getVersionX()) {
            return 1;
        }
        if (a.getVersionX() < b.getVersionX()) {
            return 0;
        }
        if (a.getVersionY() > b.getVersionY()) {
            return 1;
        }
        if (a.getVersionY() < b.getVersionY()) {
            return 0;
        }
        if (a.getVersionZ() > b.getVersionZ()) {
            return 1;
        }
        if (a.getVersionZ() < b.getVersionZ()) {
            return 0;
        }
        return 2;
    }
}

