/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.bootstrap.properties.SmtProperties;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISmsService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl
implements ISmsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    @Autowired
    private SmtProperties smtProperties;

    @Override
    public Boolean sendVcode(String vcode, String mobile) {
        String text = "\u60a8\u7684\u9a8c\u8bc1\u7801\u662f:" + vcode + ",\u8bf7\u52ff\u5411\u4efb\u4f55\u4eba\u6cc4\u9732,5\u5206\u949f\u6709\u6548\u3002";
        if (!StringUtils.checkMobile((String)mobile)) {
            log.error("mobile:{}, \u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1: {} \u5931\u8d25", (Object)mobile, (Object)text);
            return false;
        }
        log.info("\u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1: {}", (Object)text);
        String result = null;
        for (int tryCount = 0; tryCount < this.smtProperties.getTrytime(); ++tryCount) {
            result = this.batchSendTextSms(text, mobile);
            log.info("\u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1 result:{}", (Object)result);
            if (!StringUtils.isNotEmpty((String)result)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String sendTextSms(String text, String mobile) {
        log.info("\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{}", (Object)mobile, (Object)(text + this.smtProperties.getMSGSIGN()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CorpID", this.smtProperties.getCORPID());
        params.put("Pwd", this.smtProperties.getPWD());
        params.put("Content", text + this.smtProperties.getMSGSIGN());
        params.put("Mobile", mobile);
        params.put("Cell", "");
        params.put("SendTime", "");
        return this.post(this.smtProperties.getURI_SEND_SMS(), params);
    }

    @Override
    public String batchSendTextSms(String text, String mobiles) {
        log.info("\u6279\u91cf\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{}", (Object)mobiles, (Object)(text + this.smtProperties.getMSGSIGN()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CorpID", this.smtProperties.getCORPID());
        params.put("Pwd", this.smtProperties.getPWD());
        params.put("Content", text + this.smtProperties.getMSGSIGN());
        params.put("Mobile", mobiles);
        params.put("Cell", "");
        params.put("SendTime", "");
        String result = this.post(this.smtProperties.getURI_BATCHSEND_SMS(), params);
        log.info("\u6279\u91cf\u53d1\u9001\u6587\u672c\u77ed\u4fe1:{}, \u77ed\u4fe1\u5185\u5bb9 :{},\u53d1\u9001\u7ed3\u679c:{}", new Object[]{mobiles, text + this.smtProperties.getMSGSIGN(), result});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String post(String url, Map<String, String> paramsMap) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            HttpPost method = new HttpPost(url);
            if (paramsMap != null) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> param : paramsMap.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(param.getKey(), param.getValue());
                    paramList.add(pair);
                }
                method.setEntity((HttpEntity)new UrlEncodedFormEntity(paramList, this.smtProperties.getENCODING()));
            }
            if ((entity = (response = client.execute((HttpUriRequest)method)).getEntity()) != null) {
                responseText = EntityUtils.toString((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            log.error("Exception\uff1a", (Throwable)e);
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {
                log.error("Exception\uff1a", (Throwable)e);
            }
        }
        return responseText;
    }
}

