/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.sys.dao.sys.MsgMapper;
import cn.smarthse.radiationTraining.modules.sys.dto.sys.MsgDto;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysMsg;
import cn.smarthse.radiationTraining.modules.sys.param.sys.MsgQueryParam;
import cn.smarthse.radiationTraining.modules.sys.service.sys.IMsgService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.MsgStatisticsVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.MsgVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService(methods={@Method(name="pushMsg"), @Method(name="getMsgList"), @Method(name="del"), @Method(name="readMsg"), @Method(name="getUnreadMsgNum")})
public class MsgServiceImpl
extends ServiceImpl<MsgMapper, SysMsg>
implements IMsgService {
    @Transactional
    public void pushMsg(MsgDto msgDto) {
        SysMsg sysMsg = new SysMsg();
        sysMsg.setUserId(msgDto.getUserId());
        sysMsg.setMsgType(msgDto.getMsgType());
        sysMsg.setContent(msgDto.getContent());
        sysMsg.setUrl(msgDto.getUrl());
        sysMsg.setPushTime(new Date());
        this.save(sysMsg);
    }

    public LayuiGridData<MsgVo> getMsgList(MsgQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        if (param.getUserId() == null) {
            throw new ServiceException("\u7f3a\u5c11userId\uff01");
        }
        return new LayuiGridData((Page)((MsgMapper)this.baseMapper).getMsgList(param), (LayuiGridParam)param);
    }

    public Integer getUnreadMsgNum(Long userId) {
        return ((MsgMapper)this.baseMapper).getMsgList(new MsgQueryParam().setUserId(userId).setIsRead(Integer.valueOf(0))).size();
    }

    @Transactional
    public void readMsg(List<Long> msgIdList, Long userId) {
        if (userId == null) {
            throw new ServiceException("userId\u4e3a\u7a7a\uff01");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        if (!CollectionUtils.isEmpty(msgIdList)) {
            wrapper.in(SysMsg::getId, msgIdList);
        }
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(BaseBean::getIsValid, (Object)Constant.YES)).eq(SysMsg::getUserId, (Object)userId)).set(SysMsg::getIsRead, (Object)Constant.YES)).set(SysMsg::getReadTime, (Object)LocalDateTime.now());
        this.update((Wrapper)wrapper);
    }

    @Transactional
    public void del(List<Long> msgIdList, Long userId) {
        if (userId == null) {
            throw new ServiceException("userId\u4e3a\u7a7a\uff01");
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        if (!CollectionUtils.isEmpty(msgIdList)) {
            wrapper.in(SysMsg::getId, msgIdList);
        }
        wrapper.eq(SysMsg::getUserId, (Object)userId);
        this.remove((Wrapper)wrapper);
    }

    public long getUnReadNum(Long userId) {
        if (userId == null) {
            return 0L;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BaseBean::getIsValid, (Object)Constant.YES)).eq(SysMsg::getUserId, (Object)userId)).eq(SysMsg::getIsRead, (Object)Constant.NO);
        return this.count((Wrapper)wrapper);
    }

    public MsgStatisticsVo getMsgCount(Long loginUserId) {
        return ((MsgMapper)this.baseMapper).getMsgCount(loginUserId);
    }
}

