/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.sys.impl;

import cn.smarthse.radiationTraining.modules.sys.service.sys.IEmailService;
import javax.annotation.PostConstruct;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.MailSendException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl
implements IEmailService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmailServiceImpl.class);
    @Qualifier(value="emailTemplate")
    @Autowired
    private JavaMailSenderImpl mailSender;
    @Value(value="${mail.mailsign}")
    private String SUBJECT;
    @Value(value="${mail.username}")
    private String USERNAMES;
    @Value(value="${mail.password}")
    private String PASSWORDS;
    private String CURRENT_USERNAME;
    private String CURRENT_PASSWORD;
    private int CURRENT_INDEX = 0;

    @PostConstruct
    public void initProperties() {
        this.CURRENT_USERNAME = this.USERNAMES.trim().split(",")[0];
        this.CURRENT_PASSWORD = this.PASSWORDS.trim().split(",")[0];
    }

    @Override
    @Retryable(recover="recover", maxAttempts=4, backoff=@Backoff(value=200L, multiplier=1.5))
    @Async
    public void sendVcodeEmail(String toUser, String text) {
        try {
            this.doSendVcodeEmail(toUser, text);
        }
        catch (MessagingException | MailSendException e) {
            this.changeEmailAccount();
            throw new ServiceException("VCode email could not send ......");
        }
    }

    @Override
    @Retryable(recover="recover", maxAttempts=4, backoff=@Backoff(value=200L, multiplier=1.5))
    @Async
    public void sendHtmlEmail(String toUser, String htmlText) {
        try {
            this.doSendHtmlEmail(toUser, htmlText);
        }
        catch (MessagingException | MailSendException e) {
            this.changeEmailAccount();
            throw new ServiceException("Html email could not send ......");
        }
    }

    public void doSendVcodeEmail(String toUser, String text) throws MessagingException {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setFrom(this.CURRENT_USERNAME);
        message.setSubject(this.SUBJECT);
        message.setTo(toUser);
        message.setText(text);
        this.mailSender.send(message);
    }

    public void doSendHtmlEmail(String toUser, String htmlText) throws MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true, "utf-8");
        helper.setFrom(this.CURRENT_USERNAME);
        helper.setSubject(this.SUBJECT);
        helper.setTo(toUser);
        helper.setText(htmlText, true);
        this.mailSender.send(message);
    }

    public synchronized void changeEmailAccount() {
        this.CURRENT_INDEX = (this.CURRENT_INDEX + 1) % this.USERNAMES.trim().split(",").length;
        log.info("\u5f53\u524d\u90ae\u7bb1\uff1a{}\u53d1\u9001\u5931\u8d25\uff0c\u5207\u6362\u90ae\u7bb1\u8d26\u53f7\u4e3a {}", (Object)this.CURRENT_USERNAME, (Object)this.USERNAMES.trim().split(",")[this.CURRENT_INDEX]);
        this.CURRENT_USERNAME = this.USERNAMES.trim().split(",")[this.CURRENT_INDEX];
        this.CURRENT_PASSWORD = this.PASSWORDS.trim().split(",")[this.CURRENT_INDEX];
        this.mailSender.setUsername(this.CURRENT_USERNAME);
        this.mailSender.setPassword(this.CURRENT_PASSWORD);
    }

    @Recover
    public void recover(Throwable throwable, String toUser, String text) {
        log.info("\u6240\u6709\u90ae\u7bb1\u8d26\u53f7\u91cd\u8bd5\u53d1\u9001\u5b8c\u6bd5......");
        throw new ServiceException("\u90ae\u4ef6\u53d1\u9001\u5931\u8d25\uff01");
    }
}

