/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.order.impl;

import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.sys.dao.order.SysOrderMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrderLog;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderLogTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayStateEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.order.AddOrderParam;
import cn.smarthse.radiationTraining.modules.sys.param.order.QueryOrderParam;
import cn.smarthse.radiationTraining.modules.sys.param.order.UserQueryOrderParam;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderLogService;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderRefundService;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderService;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderDetailModel;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderModel;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderRefundAuditVo;
import cn.smarthse.radiationTraining.modules.sys.vo.order.UserOrderVo;
import cn.smarthse.radiationTraining.modules.training.provider.training.ITrainingProviderService;
import cn.smarthse.radiationTraining.modules.training.vo.training.TrainingDetailVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
public class SysOrderServiceImpl
extends ServiceImpl<SysOrderMapper, SysOrder>
implements ISysOrderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysOrderServiceImpl.class);
    private final ISysOrderRefundService sysOrderRefundService;
    private final ISysOrderLogService sysOrderLogService;
    private final OssClientBean ossClientBean;
    @DubboReference
    private ITrainingProviderService trainingProviderService;

    public LayuiGridData<SysOrderModel> getOrderListData(QueryOrderParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((SysOrderMapper)this.baseMapper).getOrderList(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    public void dealExpireOrder(Long userId, int orderExpireTime) {
        ((SysOrderMapper)this.baseMapper).dealExpireOrder(userId, orderExpireTime);
    }

    public LayuiGridData<SysOrderDetailModel> getUserOrderListData(UserQueryOrderParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SysOrderDetailModel> orderList = ((SysOrderMapper)this.baseMapper).getUserOrderList(param);
        if (!CollectionUtils.isEmpty(orderList)) {
            orderList.forEach(order -> order.setTrainCoverUrl(this.ossClientBean.getUrl(order.getTrainCoverUrl())));
        }
        return new LayuiGridData((Page)orderList, (LayuiGridParam)param);
    }

    @Transactional
    public SysOrderModel addOrderByUser(AddOrderParam param) {
        TrainingDetailVo training = this.trainingProviderService.getTrainingInfo(param.getGoodsId());
        if (training == null) {
            throw new ServiceException("\u4ea7\u54c1\u4e0d\u5b58\u5728\uff01");
        }
        String goodsName = training.getTrainName();
        BigDecimal goodsPrice = training.getPrice();
        if (param.getUnitPrice().compareTo(training.getPrice()) != 0) {
            throw new ServiceException("\u53c2\u6570\u5355\u4ef7\u4e0e\u5b9e\u9645\u5355\u4ef7\u4e0d\u7b26\uff01");
        }
        if (this.checkPayedByBusinessId(param.getBusinessId())) {
            throw new ServiceException("\u8be5\u5546\u54c1\u5df2\u5b8c\u6210\u652f\u4ed8\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u5355\uff01");
        }
        if (param.getQuantity() != null) {
            goodsPrice = goodsPrice.multiply(new BigDecimal(param.getQuantity()));
        }
        SysOrder sysOrder = new SysOrder();
        sysOrder.setUserId(param.getUserId());
        sysOrder.setUsername(param.getUsername());
        sysOrder.setNickname(param.getNickname());
        sysOrder.setThirdPayType(param.getThirdPayType());
        sysOrder.setPayType(OrderPayTypeEnum.ONLINE.getValue());
        sysOrder.setPayState(OrderPayStateEnum.UN_PAY.getValue());
        sysOrder.setOrderType(param.getOrderType());
        sysOrder.setGoodsId(param.getGoodsId());
        sysOrder.setSubject(goodsName);
        sysOrder.setGoodsPrice(goodsPrice);
        sysOrder.setUnitPrice(param.getUnitPrice());
        sysOrder.setQuantity(param.getQuantity());
        sysOrder.setBusinessId(param.getBusinessId());
        this.save(sysOrder);
        this.sysOrderLogService.addOrderLog(new SysOrderLog(sysOrder.getId(), OrderLogTypeEnum.PAY_SUCCESS.getValue(), OrderLogTypeEnum.PAY_SUCCESS.getName(), param.getUserId(), param.getUsername(), new Date(), ""));
        SysOrderModel sysOrderModel = new SysOrderModel();
        BeanUtils.copyProperties((Object)sysOrder, (Object)sysOrderModel);
        return sysOrderModel;
    }

    @Transactional
    public void applyRefund(Long orderId, Long currentUserId, String currentUserName) {
        SysOrder sysOrder = (SysOrder)this.getById(orderId);
        if (sysOrder == null) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (!sysOrder.getUserId().equals(currentUserId)) {
            throw new ServiceException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8be5\u8ba2\u5355\uff01");
        }
        if (OrderPayStateEnum.APPLY_REFUND.getValue().equals(sysOrder.getPayState())) {
            throw new ServiceException("\u8be5\u8ba2\u5355\u5df2\u7533\u8bf7\u9000\u6b3e\uff0c\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01");
        }
        if (!OrderPayStateEnum.PAY.getValue().equals(sysOrder.getPayState()) && !OrderPayStateEnum.FAIL_REFUND.getValue().equals(sysOrder.getPayState())) {
            throw new ServiceException("\u5df2\u652f\u4ed8\u7684\u8ba2\u5355\u624d\u80fd\u7533\u8bf7\u9000\u6b3e\uff01");
        }
        sysOrder.setPayState(OrderPayStateEnum.APPLY_REFUND.getValue());
        this.updateById(sysOrder);
        this.sysOrderRefundService.applyRefund(sysOrder, "\u7528\u6237\u4e3b\u52a8\u9000\u6b3e", currentUserId);
        this.sysOrderLogService.addOrderLog(new SysOrderLog(sysOrder.getId(), OrderLogTypeEnum.REFUND_APPLY.getValue(), OrderLogTypeEnum.REFUND_APPLY.getName(), currentUserId, currentUserName, new Date(), "\u7528\u6237\u7533\u8bf7\u9000\u6b3e"));
    }

    @Transactional
    public void delOrderByUser(Long orderId, Long userId) {
        if (orderId == null) {
            throw new ServiceException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SysOrder sysOrder = (SysOrder)this.getById(orderId);
        if (sysOrder == null) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if (!sysOrder.getUserId().equals(userId)) {
            throw new ServiceException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8be5\u8ba2\u5355\uff01");
        }
        if (!OrderPayStateEnum.CANCEL_PAY.getValue().equals(sysOrder.getPayState()) && !OrderPayStateEnum.REFUND.getValue().equals(sysOrder.getPayState())) {
            throw new ServiceException("\u53ea\u6709\u53d6\u6d88\u6216\u5df2\u9000\u6b3e\u7684\u8ba2\u5355\u624d\u80fd\u5220\u9664\uff01");
        }
        this.removeById(orderId);
    }

    public UserOrderVo getUserOrder(Long userId, Long orderId) {
        SysOrder sysOrder = (SysOrder)this.getById(orderId);
        if (sysOrder == null) {
            throw new ServiceException("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\uff01");
        }
        if (!sysOrder.getUserId().equals(userId)) {
            throw new ServiceException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8be5\u8ba2\u5355\uff01");
        }
        UserOrderVo userOrderVo = new UserOrderVo();
        BeanUtils.copyProperties((Object)sysOrder, (Object)userOrderVo);
        return userOrderVo;
    }

    public SysOrderDetailModel getOrderDetails(Long id) {
        SysOrderDetailModel sysOrder = ((SysOrderMapper)this.baseMapper).getOrderDetailsById(id);
        if (sysOrder == null) {
            throw new ServiceException("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\uff01");
        }
        return sysOrder;
    }

    public SysOrder getByBuinessId(Long businessId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)wrapper.lambda().eq(SysOrder::getBusinessId, (Object)businessId)).eq(BaseBean::getIsValid, (Object)Constant.YES);
        return (SysOrder)((SysOrderMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    public UserOrderVo getNewestUserOrderByGoodsId(Long userId, Long goodsId) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"goods_id", (Object)goodsId)).orderByDesc((Object)"create_date")).last("limit 1");
        SysOrder sysOrder = (SysOrder)this.getOne((Wrapper)wrapper);
        if (sysOrder == null) {
            return null;
        }
        if (userId != null && !sysOrder.getUserId().equals(userId)) {
            throw new ServiceException("\u60a8\u65e0\u6743\u64cd\u4f5c\u8be5\u8ba2\u5355\uff01");
        }
        UserOrderVo userOrderVo = new UserOrderVo();
        BeanUtils.copyProperties((Object)sysOrder, (Object)userOrderVo);
        return userOrderVo;
    }

    @Transactional
    public void delOrder(List<Long> idList, Long adminId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)updateWrapper.in((Object)"id", idList)).set((Object)"update_by", (Object)adminId)).set((Object)"update_date", (Object)LocalDateTime.now());
        this.update((Wrapper)updateWrapper);
    }

    public SysOrder getOrderState(Long orderId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"id", (Object)orderId)).select(new String[]{"id", "pay_state", "create_date"});
        SysOrder order = (SysOrder)this.getOne((Wrapper)queryWrapper);
        if (order == null) {
            log.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\uff1a{}\uff01", (Object)orderId);
            return null;
        }
        return order;
    }

    public SysOrderRefundAuditVo getSysOrderRefundAuditVo(Long id) {
        return ((SysOrderMapper)this.baseMapper).getSysOrderRefundAuditVo(id);
    }

    List<SysOrder> getListByBusinessAndPayType(Long businessId, Integer payType) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(SysOrder::getBusinessId, (Object)businessId)).eq(BaseBean::getIsValid, (Object)Constant.YES)).orderByDesc(BaseBean::getCreateDate);
        if (payType.equals(OrderPayStateEnum.PAY.getValue())) {
            wrapper.lambda().in(SysOrder::getPayState, new Object[]{2, 5, 6});
        } else {
            wrapper.lambda().eq(SysOrder::getPayState, (Object)payType);
        }
        return this.list((Wrapper)wrapper);
    }

    public boolean checkPayedByBusinessId(Long businessId) {
        List<SysOrder> orders = this.getListByBusinessAndPayType(businessId, OrderPayStateEnum.PAY.getValue());
        return !CollectionUtils.isEmpty(orders);
    }

    @Generated
    public SysOrderServiceImpl(ISysOrderRefundService sysOrderRefundService, ISysOrderLogService sysOrderLogService, OssClientBean ossClientBean) {
        this.sysOrderRefundService = sysOrderRefundService;
        this.sysOrderLogService = sysOrderLogService;
        this.ossClientBean = ossClientBean;
    }
}

