/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.order.impl;

import cn.smarthse.radiationTraining.modules.sys.dao.order.SysOrderRefundMapper;
import cn.smarthse.radiationTraining.modules.sys.dto.order.OrderRefundContext;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrderRefund;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderRefundStateEnum;
import cn.smarthse.radiationTraining.modules.sys.param.order.OrderRefundParam;
import cn.smarthse.radiationTraining.modules.sys.service.order.ISysOrderRefundService;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderRefundVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class SysOrderRefundServiceImpl
extends ServiceImpl<SysOrderRefundMapper, SysOrderRefund>
implements ISysOrderRefundService {
    public void saveFailOrderRefund(OrderRefundParam refundParam) {
        SysOrderRefund sysOrderRefund = new SysOrderRefund();
        sysOrderRefund.setId(refundParam.getOrderRefundId());
        sysOrderRefund.setState(OrderRefundStateEnum.FAIL.getValue());
        sysOrderRefund.setRefundFailTime(new Date());
        sysOrderRefund.setUpdateBy(refundParam.getLoginUserId());
        this.updateById(sysOrderRefund);
    }

    public void saveSuccessOrderRefund(OrderRefundParam refundParam) {
        SysOrderRefund sysOrderRefund = new SysOrderRefund();
        sysOrderRefund.setId(refundParam.getOrderRefundId());
        sysOrderRefund.setState(OrderRefundStateEnum.SUCCESS_REFUND.getValue());
        sysOrderRefund.setRefundPassTime(new Date());
        sysOrderRefund.setUpdateBy(refundParam.getLoginUserId());
        this.updateById(sysOrderRefund);
    }

    public SysOrderRefund addOrderRefundLog(OrderRefundParam param, OrderRefundContext orderRefundContext) {
        if (param == null) {
            throw new ServiceException("\u9000\u6b3e\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if (orderRefundContext == null || orderRefundContext.getOrder() == null) {
            throw new ServiceException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        SysOrderRefund orderRefund = new SysOrderRefund();
        orderRefund.setUserId(orderRefundContext.getOrder().getUserId());
        orderRefund.setOrderId(orderRefundContext.getOrder().getId());
        orderRefund.setOrderNo(orderRefundContext.getOrder().getOrderNo());
        orderRefund.setThirdPayType(orderRefundContext.getOrder().getThirdPayType());
        orderRefund.setTotalAmount(orderRefundContext.getOrder().getPayMoney());
        orderRefund.setRefundAmount(orderRefundContext.getOrder().getPayMoney());
        orderRefund.setCreateBy(param.getLoginUserId());
        orderRefund.setState(OrderRefundStateEnum.SUCCESS_REFUND.getValue());
        this.saveOrUpdate(orderRefund);
        return orderRefund;
    }

    public SysOrderRefund applyRefund(SysOrder sysOrder, String refundReason, Long userId) {
        SysOrderRefund orderRefund = new SysOrderRefund();
        orderRefund.setOrderId(sysOrder.getId());
        orderRefund.setOrderNo(sysOrder.getOrderNo());
        orderRefund.setThirdPayType(sysOrder.getThirdPayType());
        orderRefund.setTotalAmount(sysOrder.getPayMoney());
        orderRefund.setRefundAmount(sysOrder.getPayMoney());
        orderRefund.setState(OrderRefundStateEnum.APPLY_REFUND.getValue());
        orderRefund.setUserId(userId);
        orderRefund.setCreateBy(userId);
        ((SysOrderRefundMapper)this.baseMapper).insert(orderRefund);
        return orderRefund;
    }

    public List<SysOrderRefund> getOrderRefundList(Long orderId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"order_id", (Object)orderId)).eq((Object)"is_valid", (Object)true);
        return this.list((Wrapper)queryWrapper);
    }

    public List<SysOrderRefundVo> getOrderRefundVoList(Long orderId) {
        if (orderId == null) {
            return null;
        }
        return ((SysOrderRefundMapper)this.baseMapper).getOrderRefundList(orderId, null);
    }

    public List<SysOrderRefundVo> getOrderRefundVoList(Long orderId, Long userId) {
        if (orderId == null) {
            return null;
        }
        return ((SysOrderRefundMapper)this.baseMapper).getOrderRefundList(orderId, userId);
    }
}

