/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.hse.impl;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.sys.dao.hse.HseIndustryMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseIndustry;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseIndustryService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.springframework.stereotype.Service;

@Service
public class HseIndustryServiceImpl
extends ServiceImpl<HseIndustryMapper, HseIndustry>
implements IHseIndustryService {
    @Override
    public List<HseIndustry> query(HseIndustry industry, LayuiGridParam param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (industry.getLevel() != null && industry.getLevel() > 0 && industry.getPid() != null) {
            ((LambdaQueryWrapper)queryWrapper.lambda().eq(HseIndustry::getLevel, (Object)industry.getLevel())).eq(HseIndustry::getPid, (Object)industry.getPid());
        }
        if (industry.getName() != null && !industry.getName().isEmpty()) {
            queryWrapper.lambda().like(HseIndustry::getName, (Object)("%" + industry.getName() + "%"));
        }
        if (industry.getSubCode() != null) {
            queryWrapper.lambda().like(HseIndustry::getSubCode, (Object)("%" + industry.getSubCode() + "%"));
        }
        queryWrapper.lambda().orderByAsc(HseIndustry::getSort);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Long getProgenyNum(String code, Integer level) {
        if (level == 0) {
            return ((HseIndustryMapper)this.baseMapper).selectCount(null);
        }
        Long progenyNum = ((HseIndustryMapper)this.baseMapper).getProgenyNum(code);
        if (progenyNum < 0L) {
            throw new ServiceException(code + "\u884c\u4e1a\u540e\u4ee3\u8282\u70b9\u6570\u91cf\u9519\u8bef");
        }
        return progenyNum;
    }

    @Override
    public String getNameByCode(String code) {
        if (code == null) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(HseIndustry::getCode, (Object)code);
        HseIndustry industry = (HseIndustry)this.getOne((Wrapper)wrapper);
        if (industry == null) {
            return null;
        }
        return industry.getName();
    }
}

