/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.hse.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.smarthse.radiationTraining.modules.sys.converter.hse.HseCompanyConverter;
import cn.smarthse.radiationTraining.modules.sys.dao.hse.HseCompanyMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseCompany;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseIndustry;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.param.hse.CompanyCheckFactorSearchModel;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseIndustryService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.radiationTraining.modules.sys.service.user.ISysUserService;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.CompanyCheckFactorVo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HseCompanyServiceImpl
extends ServiceImpl<HseCompanyMapper, HseCompany>
implements IHseCompanyService {
    @Autowired
    private HseCompanyConverter converter;
    @Autowired
    private IHseIndustryService hseIndustryService;
    @Autowired
    private ISysAreaService sysAreaService;
    @Autowired
    private ISysUserService sysUserService;

    @Override
    public HseCompanyVo getInfoById(Long id) {
        return ((HseCompanyMapper)this.baseMapper).getInfoById(id);
    }

    @Override
    public List<HseCompanyVo> getInfosByIds(List<Long> ids) {
        return ((HseCompanyMapper)this.baseMapper).getInfosByIds(ids);
    }

    @Override
    public CompanyInfo getOldStructureInfoById(Long id) {
        HseCompanyVo vo = this.getInfoById(id);
        return vo == null ? null : this.converter.vo2ConpanyInfo(vo);
    }

    @Override
    public List<String> getRiskFactorCodesByCid(Long cid) {
        CompanyCheckFactorSearchModel param = new CompanyCheckFactorSearchModel();
        param.setCid(cid);
        CompanyCheckFactorVo companyCheckFactor = ((HseCompanyMapper)this.baseMapper).getCompanyCheckFactor(param);
        if (companyCheckFactor == null || companyCheckFactor.getHazardFactorCode() == null) {
            return null;
        }
        Object[] factorArr = companyCheckFactor.getHazardFactorCode().split(",");
        return ArrayUtil.isEmpty((Object[])factorArr) ? null : Arrays.asList(factorArr);
    }

    @Override
    public List<String> getIndustryCodesByCid(Long cid) {
        HseCompany company = (HseCompany)this.getById(cid);
        if (company == null) {
            throw new ServiceException("\u5355\u4f4d\u6570\u636e\u7f3a\u5931\uff0c\u62a5\u540d\u5931\u8d25");
        }
        if (company.getSyncSourceType() != null && company.getSyncSourceType() == 3) {
            return CollUtil.toList((Object[])new String[]{"Q841"});
        }
        if (company.getIndustryCategory() == null) {
            return null;
        }
        HseIndustry hseIndustry = (HseIndustry)this.hseIndustryService.getById(company.getIndustryCategory());
        return hseIndustry == null ? null : Collections.singletonList(hseIndustry.getCode());
    }

    @Override
    public CompanyVo getOldStructureVoById(Long id) {
        HseCompanyVo hseCompany = this.getInfoById(id);
        if (hseCompany == null) {
            return null;
        }
        SysUser sysUser = this.sysUserService.getUserByToken(String.valueOf(hseCompany.getId()));
        CompanyVo companyVo = new CompanyVo();
        companyVo.setId(hseCompany.getId());
        companyVo.setUserId(sysUser == null ? null : sysUser.getId());
        companyVo.setName(hseCompany.getName());
        companyVo.setCreditCode(hseCompany.getCreditCode());
        companyVo.setAddress(hseCompany.getRegisterAddress());
        companyVo.setAreaId(hseCompany.getAreaId());
        companyVo.setArea(this.sysAreaService.getAreaById(hseCompany.getAreaId()));
        return companyVo;
    }
}

