/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.service.hse.impl;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.radiationTraining.modules.sys.dao.hse.HseBackCompanyMapper;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseBackCompany;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveSysSettingParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IEmailProviderService;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseBackCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysSettingService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysSettingVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HseBackCompanyServiceImpl
extends ServiceImpl<HseBackCompanyMapper, HseBackCompany>
implements IHseBackCompanyService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HseBackCompanyServiceImpl.class);
    @Autowired
    private RedisLockRegistry lockRegistry;
    @DubboReference
    private IEmailProviderService emailProviderService;
    @DubboReference
    private ISysSettingService sysSettingService;

    @Override
    public boolean saveOrUpdateBatchNoLogic(Collection<HseBackCompany> entityList, int batchSize) {
        for (HseBackCompany source : entityList) {
            try {
                HseBackCompany byIdNoLogic = this.getByIdNoLogic(source.getId());
                if (byIdNoLogic == null) {
                    this.save(source);
                    continue;
                }
                this.updateByIdNoLogic(source);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    @Override
    public HseBackCompany getByIdNoLogic(Long id) {
        return ((HseBackCompanyMapper)this.baseMapper).getByIdNoLogic(id);
    }

    public void updateByIdNoLogic(HseBackCompany hseBackCompany) {
        ((HseBackCompanyMapper)this.baseMapper).updateByIdNoLogic(hseBackCompany);
    }

    @Override
    public void updateNewestUnitInfoFromSourceById() {
        Lock lock = this.lockRegistry.obtain((Object)"updateNewestUnitInfoFromSourceById_key");
        try {
            if (lock.tryLock(30L, TimeUnit.MINUTES)) {
                this.updateNewestUnitInfoFromSourceByIdWithKey();
            }
        }
        catch (Exception e) {
            log.error("exception \uff1a{}", (Object)e.toString());
        }
        finally {
            lock.unlock();
        }
    }

    public void updateNewestUnitInfoFromSourceByIdWithKey() {
        String html;
        String s;
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String email = "283558164@qq.com";
        Date before = null;
        Date current = new Date();
        SysSettingVo settingFromDB = this.sysSettingService.getSettingFromDB("20001");
        String string = s = settingFromDB == null ? null : settingFromDB.getValue();
        if (s != null) {
            try {
                before = dateformat.parse(s);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (Math.abs(System.currentTimeMillis() - before.getTime()) > 2592000000L) {
                log.warn("\u5355\u4f4d\uff1a\u66f4\u65b0\u65f6\u95f4\u4e0e\u5f53\u524d\u65f6\u95f4\u76f8\u5dee30\u5929\uff0c\u4e2d\u65ad\u66f4\u65b0");
                String html2 = "<html><body><p>\u5355\u4f4d\uff1a\u66f4\u65b0\u65f6\u95f4\u4e0e\u5f53\u524d\u65f6\u95f4\u76f8\u5dee30\u5929\uff0c\u4e2d\u65ad\u66f4\u65b0</p></body></html>";
                this.emailProviderService.sendHtmlEmail(email, html2);
                return;
            }
        } else {
            log.warn("\u5355\u4f4d\uff1a\u65e0\u66f4\u65b0\u65f6\u95f4\u7f13\u5b58\uff0c\u4e2d\u65ad\u66f4\u65b0");
            String html3 = "<html><body><p>\u5355\u4f4d\uff1a\u65e0\u66f4\u65b0\u65f6\u95f4\u7f13\u5b58\uff0c\u4e2d\u65ad\u66f4\u65b0</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html3);
            return;
        }
        int pageSize = 1000;
        int max = 180000;
        int min = 3000;
        boolean ifException = false;
        List<Long> sourceCompanyIdList = ((HseBackCompanyMapper)this.baseMapper).getSourceCompanyIdList(before);
        if (sourceCompanyIdList.size() == 0) {
            SaveSysSettingParam param = new SaveSysSettingParam();
            param.setId(settingFromDB.getId());
            param.setCode(settingFromDB.getCode());
            param.setValue(dateformat.format(current));
            this.sysSettingService.saveSetting(param);
            String html4 = "<html><body><p>\u5355\u4f4d\u65e0\u6570\u636e\u66f4\u65b0</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html4);
            return;
        }
        if (sourceCompanyIdList.size() > max) {
            log.warn("\u5355\u4f4d\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceCompanyIdList.size() + "\u6761\uff0c\u5df2\u4e2d\u65ad\u66f4\u65b0\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38");
            String html5 = "<html><body><p>\u5355\u4f4d\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceCompanyIdList.size() + "\u6761\uff0c\u5df2\u4e2d\u65ad\u66f4\u65b0\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html5);
            return;
        }
        if (sourceCompanyIdList.size() > min && sourceCompanyIdList.size() < max) {
            log.warn("\u5355\u4f4d\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceCompanyIdList.size() + "\u6761\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38");
            html = "<html><body><p>\u5355\u4f4d\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceCompanyIdList.size() + "\u6761\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html);
        }
        try {
            List split = ListUtil.split(sourceCompanyIdList, (int)pageSize);
            Integer pages = split.size();
            for (int i = 0; i < pages; ++i) {
                List<HseBackCompany> temp = null;
                try {
                    List idList = (List)split.get(i);
                    temp = ((HseBackCompanyMapper)this.baseMapper).getSourceCompanyInfoByIds(idList);
                    this.saveOrUpdateBatchNoLogic(temp, pageSize);
                    continue;
                }
                catch (Exception e) {
                    ifException = true;
                    e.printStackTrace();
                    log.warn(e.getMessage());
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html><body>");
                    stringBuilder.append("<p>\u5355\u4f4d\u6570\u636e\u6e90\u66f4\u65b0\u5f02\u5e38</p>");
                    if (!CollectionUtils.isEmpty(temp)) {
                        stringBuilder.append("<p>\u5355\u4f4did\u8303\u56f4:").append(temp.get(0).getId()).append("-").append(temp.get(temp.size() - 1).getId()).append("</p>");
                    }
                    stringBuilder.append("<p>\u65f6\u95f4\u53c2\u6570:").append(before).append("</p>");
                    stringBuilder.append("<p>").append(e.getMessage()).append("</p>");
                    stringBuilder.append("</body></html>");
                    this.emailProviderService.sendHtmlEmail(email, stringBuilder.toString());
                }
            }
            if (ifException) {
                return;
            }
            SaveSysSettingParam param = new SaveSysSettingParam();
            param.setId(settingFromDB.getId());
            param.setCode(settingFromDB.getCode());
            param.setValue(dateformat.format(current));
            this.sysSettingService.saveSetting(param);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn(e.getMessage());
            String html6 = "<html><body><p>\u5355\u4f4d\u6570\u636e\u6e90\u66f4\u65b0\u5f02\u5e38</p><p>" + e.getMessage() + "</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html6);
            return;
        }
        html = "<html><body><p>\u5355\u4f4d\u6570\u636e\u6e90\u66f4\u65b0\u5b8c\u6210</p><p>\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - current.getTime()) / 1000L + "\u79d2</p><p>\u4e00\u5171\u66f4\u65b0\uff1a" + sourceCompanyIdList.size() + "\u6761</p></body></html>";
        this.emailProviderService.sendHtmlEmail(email, html);
    }

    @Override
    public void updateNewestRayUnitInfoFromSourceById() {
        Lock lock = this.lockRegistry.obtain((Object)"updateNewestRayUnitInfoFromSourceById_key");
        try {
            if (lock.tryLock(30L, TimeUnit.MINUTES)) {
                this.updateNewestRayUnitInfoFromSourceByIdWithKey();
            }
        }
        catch (Exception e) {
            log.error("exception \uff1a{}", (Object)e.toString());
        }
        finally {
            lock.unlock();
        }
    }

    public void updateNewestRayUnitInfoFromSourceByIdWithKey() {
        String html;
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String email = "283558164@qq.com";
        Date before = null;
        Date current = new Date();
        SysSettingVo settingFromDB = this.sysSettingService.getSettingFromDB("20003");
        before = this.getDateForRay(settingFromDB, dateformat, email);
        if (before == null) {
            return;
        }
        int pageSize = 1000;
        int max = 160000;
        int min = 3000;
        boolean ifException = false;
        List<Long> sourceIdList = ((HseBackCompanyMapper)this.baseMapper).getSourceRayUnitId(before);
        if (sourceIdList.size() == 0) {
            SaveSysSettingParam param = new SaveSysSettingParam();
            param.setId(settingFromDB.getId());
            param.setCode(settingFromDB.getCode());
            param.setValue(dateformat.format(current));
            this.sysSettingService.saveSetting(param);
            String html2 = "<html><body><p>\u653e\u5c04\u533b\u9662\u65e0\u6570\u636e\u66f4\u65b0</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html2);
            return;
        }
        if (sourceIdList.size() > max) {
            log.warn("\u653e\u5c04\u533b\u9662\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceIdList.size() + "\u6761\uff0c\u5df2\u4e2d\u65ad\u66f4\u65b0\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38");
            String html3 = "<html><body><p>\u653e\u5c04\u533b\u9662\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceIdList.size() + "\u6761\uff0c\u5df2\u4e2d\u65ad\u66f4\u65b0\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html3);
            return;
        }
        if (sourceIdList.size() > min && sourceIdList.size() < max) {
            log.warn("\u653e\u5c04\u533b\u9662\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceIdList.size() + "\u6761\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38");
            html = "<html><body><p>\u653e\u5c04\u533b\u9662\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceIdList.size() + "\u6761\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html);
        }
        try {
            List split = ListUtil.split(sourceIdList, (int)pageSize);
            Integer pages = split.size();
            for (int i = 0; i < pages; ++i) {
                List<HseBackCompany> temp = null;
                try {
                    List idList = (List)split.get(i);
                    temp = ((HseBackCompanyMapper)this.baseMapper).getSourceRayInfoByIds(idList);
                    this.saveOrUpdateBatchNoLogic(temp, pageSize);
                    continue;
                }
                catch (Exception e) {
                    ifException = true;
                    e.printStackTrace();
                    log.warn(e.getMessage());
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html><body>");
                    stringBuilder.append("<p>\u653e\u5c04\u533b\u9662\u6570\u636e\u6e90\u66f4\u65b0\u5f02\u5e38</p>");
                    if (!CollectionUtils.isEmpty(temp)) {
                        stringBuilder.append("<p>\u653e\u5c04\u533b\u9662id\u8303\u56f4:").append(temp.get(0).getId()).append("-").append(temp.get(temp.size() - 1).getId()).append("</p>");
                    }
                    stringBuilder.append("<p>\u65f6\u95f4\u53c2\u6570:").append(before).append("</p>");
                    stringBuilder.append("<p>").append(e.getMessage()).append("</p>");
                    stringBuilder.append("</body></html>");
                    this.emailProviderService.sendHtmlEmail(email, stringBuilder.toString());
                }
            }
            if (ifException) {
                return;
            }
            SaveSysSettingParam param = new SaveSysSettingParam();
            param.setId(settingFromDB.getId());
            param.setCode(settingFromDB.getCode());
            param.setValue(dateformat.format(current));
            this.sysSettingService.saveSetting(param);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn(e.getMessage());
            String html4 = "<html><body><p>\u653e\u5c04\u533b\u9662\u6570\u636e\u6e90\u66f4\u65b0\u5f02\u5e38</p><p>" + e.getMessage() + "</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html4);
            return;
        }
        html = "<html><body><p>\u653e\u5c04\u533b\u9662\u6570\u636e\u6e90\u66f4\u65b0\u5b8c\u6210</p><p>\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - current.getTime()) / 1000L + "\u79d2</p><p>\u4e00\u5171\u66f4\u65b0\uff1a" + sourceIdList.size() + "\u6761</p></body></html>";
        this.emailProviderService.sendHtmlEmail(email, html);
    }

    private Date getDateForRay(SysSettingVo sysSettingVo, DateFormat dateformat, String email) {
        String s = sysSettingVo == null ? null : sysSettingVo.getValue();
        Date before = null;
        if (s != null) {
            try {
                before = dateformat.parse(s);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (Math.abs(System.currentTimeMillis() - before.getTime()) > 2592000000L) {
                log.warn("\u653e\u5c04\u533b\u9662\uff1a\u66f4\u65b0\u65f6\u95f4\u4e0e\u5f53\u524d\u65f6\u95f4\u76f8\u5dee30\u5929\uff0c\u4e2d\u65ad\u66f4\u65b0");
                String html = "<html><body><p>\u653e\u5c04\u533b\u9662\uff1a\u66f4\u65b0\u65f6\u95f4\u4e0e\u5f53\u524d\u65f6\u95f4\u76f8\u5dee30\u5929\uff0c\u4e2d\u65ad\u66f4\u65b0</p></body></html>";
                this.emailProviderService.sendHtmlEmail(email, html);
                return null;
            }
        } else {
            log.warn("\u653e\u5c04\u533b\u9662\uff1a\u65e0\u66f4\u65b0\u65f6\u95f4\u7f13\u5b58\uff0c\u4e2d\u65ad\u66f4\u65b0");
            String html = "<html><body><p>\u653e\u5c04\u533b\u9662\uff1a\u65e0\u66f4\u65b0\u65f6\u95f4\u7f13\u5b58\uff0c\u4e2d\u65ad\u66f4\u65b0</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html);
            return null;
        }
        return before;
    }

    @Override
    public void updateNewestORGInfoFromSourceById() {
        Lock lock = this.lockRegistry.obtain((Object)"updateNewestORGInfoFromSourceByIdWithKey_key");
        try {
            if (lock.tryLock(20L, TimeUnit.MINUTES)) {
                this.updateNewestORGInfoFromSourceByIdWithKey();
            }
        }
        catch (Exception e) {
            log.error("exception \uff1a{}", (Object)e.toString());
        }
        finally {
            lock.unlock();
        }
    }

    public void updateNewestORGInfoFromSourceByIdWithKey() {
        String html;
        String s;
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String email = "283558164@qq.com";
        Date before = null;
        Date current = new Date();
        SysSettingVo settingFromDB = this.sysSettingService.getSettingFromDB("20002");
        String string = s = settingFromDB == null ? null : settingFromDB.getValue();
        if (s != null) {
            try {
                before = dateformat.parse(s);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (Math.abs(System.currentTimeMillis() - before.getTime()) > 2592000000L) {
                log.warn("\u673a\u6784\uff1a\u66f4\u65b0\u65f6\u95f4\u4e0e\u5f53\u524d\u65f6\u95f4\u76f8\u5dee30\u5929\uff0c\u4e2d\u65ad\u66f4\u65b0");
                String html2 = "<html><body><p>\u673a\u6784\uff1a\u66f4\u65b0\u65f6\u95f4\u4e0e\u5f53\u524d\u65f6\u95f4\u76f8\u5dee30\u5929\uff0c\u4e2d\u65ad\u66f4\u65b0</p></body></html>";
                this.emailProviderService.sendHtmlEmail(email, html2);
                return;
            }
        } else {
            log.warn("\u673a\u6784\uff1a\u65e0\u66f4\u65b0\u65f6\u95f4\u7f13\u5b58\uff0c\u4e2d\u65ad\u66f4\u65b0");
            String html3 = "<html><body><p>\u673a\u6784\uff1a\u65e0\u66f4\u65b0\u65f6\u95f4\u7f13\u5b58\uff0c\u4e2d\u65ad\u66f4\u65b0</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html3);
            return;
        }
        int pageSize = 1000;
        int max = 50000;
        int min = 3000;
        boolean ifException = false;
        List<Long> sourceOrgIdList = ((HseBackCompanyMapper)this.baseMapper).getSourceOrgId(before);
        if (sourceOrgIdList.size() == 0) {
            SaveSysSettingParam param = new SaveSysSettingParam();
            param.setId(settingFromDB.getId());
            param.setCode(settingFromDB.getCode());
            param.setValue(dateformat.format(current));
            this.sysSettingService.saveSetting(param);
            String html4 = "<html><body><p>\u673a\u6784\u65e0\u6570\u636e\u66f4\u65b0</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html4);
            return;
        }
        if (sourceOrgIdList.size() > max) {
            log.warn("\u673a\u6784\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceOrgIdList.size() + "\u6761\uff0c\u5df2\u4e2d\u65ad\u66f4\u65b0\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38");
            String html5 = "<html><body><p>\u673a\u6784\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceOrgIdList.size() + "\u6761\uff0c\u5df2\u4e2d\u65ad\u66f4\u65b0\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html5);
            return;
        }
        if (sourceOrgIdList.size() > min && sourceOrgIdList.size() < max) {
            log.warn("\u673a\u6784\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceOrgIdList.size() + "\u6761\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38");
            html = "<html><body><p>\u673a\u6784\u66f4\u65b0\u6570\u636e\u4e00\u5171" + sourceOrgIdList.size() + "\u6761\uff0c\u8bf7\u67e5\u770b\u662f\u5426\u5f02\u5e38</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html);
        }
        try {
            List split = ListUtil.split(sourceOrgIdList, (int)pageSize);
            int pages = split.size();
            for (int i = 0; i < pages; ++i) {
                List<HseBackCompany> temp = null;
                try {
                    List idList = (List)split.get(i);
                    temp = ((HseBackCompanyMapper)this.baseMapper).getSourceOrgInfoByIds(idList);
                    this.saveOrUpdateBatchNoLogic(temp, pageSize);
                    continue;
                }
                catch (Exception e) {
                    ifException = true;
                    e.printStackTrace();
                    log.warn(e.getMessage());
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html><body>");
                    stringBuilder.append("<p>\u673a\u6784\u6570\u636e\u6e90\u66f4\u65b0\u5f02\u5e38</p>");
                    if (!CollectionUtils.isEmpty(temp)) {
                        stringBuilder.append("<p>\u673a\u6784id\u8303\u56f4:").append(temp.get(0).getId()).append("-").append(temp.get(temp.size() - 1).getId()).append("</p>");
                    }
                    stringBuilder.append("<p>\u65f6\u95f4\u53c2\u6570:").append(before).append("</p>");
                    stringBuilder.append("<p>").append(e.getMessage()).append("</p>");
                    stringBuilder.append("</body></html>");
                    this.emailProviderService.sendHtmlEmail(email, stringBuilder.toString());
                }
            }
            if (ifException) {
                return;
            }
            SaveSysSettingParam param = new SaveSysSettingParam();
            param.setId(settingFromDB.getId());
            param.setCode(settingFromDB.getCode());
            param.setValue(dateformat.format(current));
            this.sysSettingService.saveSetting(param);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn(e.getMessage());
            String html6 = "<html><body><p>\u673a\u6784\u6570\u636e\u6e90\u66f4\u65b0\u5f02\u5e38</p><p>" + e.getMessage() + "</p></body></html>";
            this.emailProviderService.sendHtmlEmail(email, html6);
            return;
        }
        html = "<html><body><p>\u673a\u6784\u6570\u636e\u6e90\u66f4\u65b0\u5b8c\u6210</p><p>\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - current.getTime()) / 1000L + "\u79d2</p><p>\u4e00\u5171\u66f4\u65b0\uff1a" + sourceOrgIdList.size() + "\u6761</p></body></html>";
        this.emailProviderService.sendHtmlEmail(email, html);
    }

    @Override
    public HseBackCompany getNewHseCompanyById(Long id) {
        return ((HseBackCompanyMapper)this.baseMapper).getNewHseCompanyById(id);
    }

    @Override
    public List<HseBackCompany> listBackCompanyById(List<Long> idList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(HseBackCompany::getId, idList);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public HseBackCompany getNewRayCompanyById(Long id) {
        return ((HseBackCompanyMapper)this.baseMapper).getNewRayCompanyById(id);
    }

    @Override
    public HseBackCompany getNewHseOrgById(Long id) {
        return ((HseBackCompanyMapper)this.baseMapper).getNewHseOrgById(id);
    }
}

