/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.provider.user.info;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.dto.user.info.ImportCompanyData;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompany;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompanyRisk;
import cn.smarthse.radiationTraining.modules.sys.param.sys.AddSysCompanyRiskParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SearchCompanyPageParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.QueryCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.info.SaveCompanyParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.info.ICompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysCompanyRiskService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysCompanyService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyExportListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.RhoCompanyListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.SearchCompanyVo;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class CompanyProviderServiceImpl
implements ICompanyProviderService {
    private final ISysCompanyService companyService;
    private final ISysAreaService areaService;
    private final ISysCompanyRiskService companyRiskService;

    public LayuiGridData<CompanyListVo> getCompanyList(QueryCompanyParam param) {
        return this.companyService.getCompanyList(param);
    }

    public LayuiGridData<RhoCompanyListVo> getCompanyListForRho(QueryCompanyParam param) {
        return this.companyService.getCompanyListForRho(param);
    }

    public CompanyVo getCompany(Long id) {
        return this.companyService.getCompany(id);
    }

    public Long getUidById(Long id) {
        SysCompany sysCompany = (SysCompany)this.companyService.getById(id);
        if (sysCompany == null) {
            return null;
        }
        return sysCompany.getUserId();
    }

    @Transactional
    public void saveUser(SaveCompanyParam param) {
        this.companyService.saveCompany(param);
    }

    @Transactional
    public SysCompany save(SysCompany company) {
        SysCompany companyByName = this.companyService.getCompanyByName(company.getName());
        if (companyByName != null) {
            throw new ServiceException("\u516c\u53f8\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        SysCompany companyByCode = this.companyService.getCompanyByCreditCode(company.getCreditCode());
        if (companyByCode != null) {
            throw new ServiceException("\u4f01\u4e1a\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        company.setAreaAddress(this.areaService.getAreaAddress(company.getAreaId()));
        this.companyService.save(company);
        return company;
    }

    public void importCompany(List<ImportCompanyData> list) {
        this.companyService.importCompany(list);
    }

    public List<CompanyExportListVo> getExportCompanyList(QueryCompanyParam param) {
        return this.companyService.getExportCompanyList(param);
    }

    public List<SearchCompanyVo> searchCompanyByKeywordForSelect(String keyword, Integer ifIncludeSelected) {
        return this.companyService.searchCompanyByKeywordForSelect(keyword, ifIncludeSelected);
    }

    public LayuiGridData<SearchCompanyVo> searchCompanyPageByKeywordAndArea(SearchCompanyPageParam param) {
        return this.companyService.searchCompanyPageByKeywordAndAreaForSelect(param);
    }

    public void synRiskFactor(List<AddSysCompanyRiskParam> paramList) {
        this.companyRiskService.synRisk(paramList);
    }

    public List<SysCompanyRisk> getRiskFactor(Long cid) {
        return this.companyRiskService.getByCid(cid);
    }

    @Generated
    public CompanyProviderServiceImpl(ISysCompanyService companyService, ISysAreaService areaService, ISysCompanyRiskService companyRiskService) {
        this.companyService = companyService;
        this.areaService = areaService;
        this.companyRiskService = companyRiskService;
    }
}

