/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.provider.user;

import cn.hutool.core.bean.BeanUtil;
import cn.smarthse.modules.health.supervise.entity.trainPlan.TrainAttendModel;
import cn.smarthse.modules.health.supervise.model.onlineTrain.TrainStaffInfoModel;
import cn.smarthse.modules.health.supervise.service.trainPlan.ISyncTrainInfoService;
import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.converter.UserToAdminDtoMap;
import cn.smarthse.radiationTraining.modules.sys.converter.user.UserConverter;
import cn.smarthse.radiationTraining.modules.sys.dto.AreaDto;
import cn.smarthse.radiationTraining.modules.sys.dto.user.UserToAdminDto;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompany;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysUserInfo;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.QueryUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterXhUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.SaveUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.UpdateHeadImgParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.EditUserParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.IMsgProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysCompanyStaffProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserProviderService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysParamService;
import cn.smarthse.radiationTraining.modules.sys.service.user.ISysUserService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysUserInfoService;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.HSEUserInfoVo;
import java.util.Collection;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.annotation.DubboService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
public class UserProviderServiceImpl
implements IUserProviderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserProviderServiceImpl.class);
    private final ISysUserService userService;
    private final ISysAreaService sysAreaService;
    private final ISysUserInfoService userInfoService;
    private final ISysCompanyService companyService;
    private final IMsgProviderService msgProviderService;
    private final UserToAdminDtoMap userToAdminDtoMap;
    private final UserConverter userConverter;
    private final ISysParamService sysParamService;
    private final OssClientBean ossClientBean;
    @DubboReference(registry={"public_nacos"})
    private ISyncTrainInfoService syncTrainInfoService;
    @DubboReference
    private ISysCompanyStaffProviderService companyStaffProviderService;

    public UserToAdminDto getUserDto(Long userId) {
        SysUser user = (SysUser)this.userService.getById(userId);
        return this.userToAdminDtoMap.user2UserToAdminDto(user);
    }

    public UserVo getUserVo(Long userId) {
        SysUser user = (SysUser)this.userService.getById(userId);
        if (user == null) {
            return null;
        }
        UserVo userVo = this.userConverter.user2UserVo(user);
        AreaDto areaDto = this.sysAreaService.getAreaById(user.getAreaId());
        userVo.setArea(areaDto);
        return userVo;
    }

    public PersonalUserVo getPersonalUserInfo(Long userId) {
        SysUser user = (SysUser)this.userService.getById(userId);
        if (user == null) {
            return null;
        }
        PersonalUserVo userVo = new PersonalUserVo().setId(user.getId()).setName(user.getName()).setUsername(user.getUsername()).setEmail(user.getEmail()).setIsTest(user.getIsTest()).setPhone(user.getPhone() == null ? user.getUsername() : user.getPhone()).setAvatar(this.ossClientBean.getUrl(user.getAvatar()));
        SysUserInfo info = this.userInfoService.getSysUserInfo(userId);
        if (info != null) {
            userVo = userVo.setIdcard(info.getIdcard()).setPhotoUrl(this.ossClientBean.getUrl(info.getPhotoUrl())).setIdcardType(info.getIdcardType()).setEducation(info.getEducation()).setWorkType(info.getWorkType()).setRadiationWorkDate(info.getRadiationWorkDate()).setResidueIdcardLimit(info.getResidueIdcardLimit());
            if (StringUtils.isNotEmpty((String)info.getEducation())) {
                userVo.setEducationStr(this.sysParamService.getNameByCode(info.getEducation()));
            }
            if (StringUtils.isNotEmpty((String)info.getWorkType())) {
                userVo.setWorkTypeStr(this.sysParamService.getNameByCode(info.getWorkType()));
            }
            userVo.setSex(info.getSex());
            SysCompany company = this.companyService.getCompanyByUserInfoId(info.getId());
            if (company != null) {
                userVo = userVo.setCompanyId(company.getId()).setCompanyNname(company.getName()).setCreditCode(company.getCreditCode()).setAreaId(company.getAreaId()).setAddressDetail(company.getAddress());
                if (company.getAreaId() != null) {
                    userVo.setFullAddress(this.sysAreaService.getAreaAddress(company.getAreaId(), "") + (company.getAddress() == null ? "" : company.getAddress()));
                }
            }
            this.initCompanyInfoForWqxx(userVo);
        }
        userVo.setTotalMsgNum(this.msgProviderService.getMsgCount(userId).getTotal());
        return userVo.setUnreadMsgNum(this.msgProviderService.getUnreadMsgNum(userId));
    }

    public void modifyPassword(Long userId, String password) {
        this.userService.modifyPassword(userId, password);
    }

    public String getPhotoUrl(Long userId) {
        SysUserInfo userInfo = this.userInfoService.getSysUserInfo(userId);
        return userInfo == null ? null : userInfo.getPhotoUrl();
    }

    public void saveUser(SaveUserParam param) {
        this.userService.saveUser(param);
    }

    public void updateHeadImg(UpdateHeadImgParam param) {
        SysUser sysUser = (SysUser)this.userService.getById(param.getUserId());
        sysUser.setAvatar(param.getUrl());
        this.userService.updateById(sysUser);
    }

    public HSEUserInfoVo getHSEPersonalInfo(Long loginUserId, String idcard, String name) {
        TrainAttendModel trainAttendModel = new TrainAttendModel();
        trainAttendModel.setIdCard(idcard);
        trainAttendModel.setOperationType(Byte.valueOf((byte)1));
        TrainStaffInfoModel trainStaffInfoModel = this.syncTrainInfoService.getOrUpdateStaffInfo(trainAttendModel);
        if (!StringUtils.isEmpty((CharSequence)trainStaffInfoModel.getMessage())) {
            if (trainStaffInfoModel.getMessage().equals("\u672a\u67e5\u8be2\u5230\u8be5\u4eba\u5458\u4fe1\u606f")) {
                return null;
            }
            throw new ServiceException(trainStaffInfoModel.getMessage());
        }
        return (HSEUserInfoVo)BeanUtil.copyProperties((Object)trainStaffInfoModel, HSEUserInfoVo.class, (String[])new String[0]);
    }

    public void del(List<Long> idList, Long adminId) {
        int userType = 1;
        this.userService.del(idList, userType, adminId);
    }

    public void forbiddenUser(ForbiddenParam param) {
        this.userService.forbiddenUser(param);
    }

    public void resetPassword(List<Long> idList, Long adminId) {
        this.userService.resetPassword(idList, adminId);
    }

    public SysUser personalUserRegister(RegisterUserParam userParam) {
        return this.userService.personalUserRegister(userParam);
    }

    public SysUser personalUserRegisterForXh(RegisterXhUserParam userParam) {
        return this.userService.personalUserRegisterForXh(userParam);
    }

    public void createUserForImport(List<RegisterUserParam> userParamList) {
        this.userService.createUserForImport(userParamList);
    }

    public SysUser getOneByEmail(String email) {
        return this.userService.getOneByEmail(email);
    }

    public SysUser getOneByIdCard(String idCard) {
        return this.userService.getOneByIdCard(idCard);
    }

    public SysUser selectUserByPhone(String phone) {
        return this.userService.selectUserByPhone(phone);
    }

    public SysUser getUserByToken(String token) {
        return this.userService.getUserByToken(token);
    }

    public SysUser getUserByToken(String token, Integer userType) {
        return this.userService.getUserByToken(token, userType);
    }

    public SysUser getUserByUsername(String username, Integer userType) {
        return this.userService.getUserByUsername(username, userType);
    }

    public SysUser getUserByPhone(String phone) {
        return this.userService.getUserByPhone(phone);
    }

    public SysUser getUserById(Long id) {
        return (SysUser)this.userService.getById(id);
    }

    public SysUser getFullUserInfoById(Long userId) {
        SysUser sysUser = (SysUser)this.userService.getById(userId);
        if (sysUser == null) {
            return null;
        }
        SysUserInfo userInfo = this.userInfoService.getSysUserInfo(userId);
        sysUser.setSysUserInfo(userInfo);
        return sysUser;
    }

    public SysUser getCompanyUserByToken(Long token) {
        return this.userService.getCompanyUserByToken(token, 2);
    }

    public SysUser selectUserById(Long userId) {
        return (SysUser)this.userService.getById(userId);
    }

    public Long register(String phone, String ... args) {
        return this.userService.register(phone, args);
    }

    public void modifyPasswordByPhone(String phone, String newPassword) {
        this.userService.modifyPasswordByPhone(phone, newPassword);
    }

    public void modifyPasswordByEmail(String email, String newPassword) {
        this.userService.modifyPasswordByEmail(email, newPassword);
    }

    public void modifyPasswordByOldPwd(String phone, String oldPassword, String newPassword) {
        this.userService.modifyPasswordByOldPwd(phone, oldPassword, newPassword);
    }

    public void modifyPasswordByOldPwd(Long userId, String oldPassword, String newPassword) {
        this.userService.modifyPasswordByOldPwd(userId, oldPassword, newPassword);
    }

    public boolean updateById(SysUser user) {
        return this.userService.updateById(user);
    }

    public LayuiGridData<UserListVo> getUserList(QueryUserParam param) {
        return this.userService.getUserList(param);
    }

    public void editPersonal(EditUserParam editUserParam) {
        this.userService.editPersonal(editUserParam);
    }

    public void editXhPersonal(EditUserParam editUserParam) {
        this.userService.editXhPersonal(editUserParam);
    }

    public Integer getEnrollTime(Long uid) {
        return this.userService.getEnrollTime(uid);
    }

    public void ifCanEditPersonalUserBatch(List<Long> list, String loginUsername, Integer userType, Integer userOptRole, Long superviseArea) {
        this.userService.ifCanEditPersonalUserBatch(list, loginUsername, userType, userOptRole, superviseArea);
    }

    public void ifCanRmForPersonal(List<Long> idList, String loginUsername, Integer userFrom, Integer useOptRole) {
        this.userService.ifCanRmForPersonal(idList, loginUsername, userFrom, useOptRole);
    }

    public void changePasswordRegularly() {
        this.userService.changePasswordRegularly();
    }

    public void manuallyGenUnitAccount(Long cid) {
        this.userService.manuallyGenUnitAccount(cid);
    }

    public SysUser getUserByZlbUserId(String zlbUserId) {
        return this.userService.getUserByZlbUserId(zlbUserId);
    }

    @Transactional
    public void bindZlbUserId(Long userId, String zlbUserId) {
        SysUser user = (SysUser)this.userService.getById(userId);
        if (user == null) {
            log.warn("\u7ed1\u5b9azlbUserId\u5931\u8d25\uff0c\u8d26\u53f7\u4e0d\u5b58\u5728\uff01gjUserId\uff1a{}-zlbUserId\uff1a{}", (Object)userId, (Object)zlbUserId);
            return;
        }
        if (!StringUtils.isBlank((CharSequence)user.getZlbUserId())) {
            log.warn("\u7ed1\u5b9azlbUserId\u5931\u8d25\uff0c\u8d26\u53f7\u5df2\u7ed1\u5b9azlbUserId\uff01gjUserId\uff1a{}-zlbUserId\uff1a{}-existsZlbUserId\uff1a{}", new Object[]{userId, zlbUserId, user.getZlbUserId()});
            return;
        }
        SysUser sysUser = new SysUser();
        sysUser.setId(userId);
        sysUser.setZlbUserId(zlbUserId);
        this.userService.updateById(sysUser);
    }

    public void updateIdcard(Long userId, String name, String idcard, Integer idcardType, Long areaId) {
        this.userService.bindIdcard(userId, name, idcard, idcardType, areaId);
    }

    public List<Long> listAllWxUserId() {
        return this.userService.selectAllWxUserId();
    }

    public long getSameUsernameCount(String usernamePrefix) {
        return this.userService.getSameUsernameCount(usernamePrefix);
    }

    private void initCompanyInfoForWqxx(PersonalUserVo userVo) {
        List companyList = this.companyStaffProviderService.getByUidAndSource(userVo.getId(), Integer.valueOf(2));
        if (CollectionUtils.isEmpty((Collection)companyList) || companyList.get(0) == null) {
            return;
        }
        userVo.setCompanyIdForWqxx(((CompanyListVo)companyList.get(0)).getId());
        userVo.setCompanyNameForWqxx(((CompanyListVo)companyList.get(0)).getName());
    }

    @Generated
    public UserProviderServiceImpl(ISysUserService userService, ISysAreaService sysAreaService, ISysUserInfoService userInfoService, ISysCompanyService companyService, IMsgProviderService msgProviderService, UserToAdminDtoMap userToAdminDtoMap, UserConverter userConverter, ISysParamService sysParamService, OssClientBean ossClientBean) {
        this.userService = userService;
        this.sysAreaService = sysAreaService;
        this.userInfoService = userInfoService;
        this.companyService = companyService;
        this.msgProviderService = msgProviderService;
        this.userToAdminDtoMap = userToAdminDtoMap;
        this.userConverter = userConverter;
        this.sysParamService = sysParamService;
        this.ossClientBean = ossClientBean;
    }
}

