/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.provider.user;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.converter.UserToAdminDtoMap;
import cn.smarthse.radiationTraining.modules.sys.converter.user.UserConverter;
import cn.smarthse.radiationTraining.modules.sys.dto.AreaDto;
import cn.smarthse.radiationTraining.modules.sys.dto.user.UserToAdminDto;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseIndustry;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysUserInfo;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.CorpStafferRegisterParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.EditCropParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.QueryUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.RegisterCompanyUserParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.SaveUserCropParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.UpdateHeadImgParam;
import cn.smarthse.radiationTraining.modules.sys.provider.user.IUserCropProviderService;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseIndustryService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.IMsgService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysAreaService;
import cn.smarthse.radiationTraining.modules.sys.service.user.ISysUserService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.user.info.ISysUserInfoService;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CidTokenMapVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CompanyModifyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropVo;
import java.util.List;
import java.util.Set;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class UserCropProviderServiceImpl
implements IUserCropProviderService {
    private final ISysUserService userService;
    private final ISysUserInfoService userInfoService;
    private final ISysCompanyService sysCompanyService;
    private final IHseCompanyService hseCompanyService;
    private final ISysAreaService sysAreaService;
    private final UserToAdminDtoMap userToAdminDtoMap;
    private final UserConverter userConverter;
    private final ISysUserService sysUserService;
    private final IMsgService msgService;
    private final IHseIndustryService industryService;

    public UserToAdminDto getUserDto(Long userId) {
        SysUser user = (SysUser)this.userService.getById(userId);
        return this.userToAdminDtoMap.user2UserToAdminDto(user);
    }

    public UserCropVo getUserVo(Long userId) {
        SysUser user = (SysUser)this.userService.getById(userId);
        SysUserInfo info = this.userInfoService.getSysUserInfo(userId);
        if (user == null) {
            return null;
        }
        UserCropVo result = this.userConverter.user2UserCropVo(user);
        result.setHeadImg(info.getPhotoUrl());
        HseCompanyVo company = this.hseCompanyService.getInfoById((long)user.getToken());
        if (company != null) {
            HseIndustry industry = (HseIndustry)this.industryService.getById(company.getIndustryCategory());
            result.setCid(company.getId());
            result.setCreditCode(company.getCreditCode());
            result.setContact(company.getLegalName());
            result.setContactTel(company.getLegalTel());
            result.setRegisteredAddress(company.getSupervisionAreaId() + ">" + company.getRegisterAddress());
            result.setIndustryName(industry == null ? "" : industry.getName());
        }
        AreaDto areaDto = this.sysAreaService.getAreaById(user.getAreaId());
        result.setArea(areaDto);
        return result;
    }

    public UserCropVo getFullUserInfo(Long userId) {
        SysUser user = (SysUser)this.userService.getById(userId);
        SysUserInfo info = this.userInfoService.getSysUserInfo(userId);
        if (user == null) {
            return null;
        }
        UserCropVo result = this.userConverter.user2UserCropVo(user);
        result.setHeadImg(info.getPhotoUrl());
        HseCompanyVo hseCompany = this.hseCompanyService.getInfoById((long)user.getToken());
        if (hseCompany != null) {
            result.setCid(hseCompany.getId());
            result.setCreditCode(hseCompany.getUnifiedSocialCc());
            result.setName(hseCompany.getName());
            result.setContact(hseCompany.getOccManagerName());
            result.setContactTel(hseCompany.getCompanyContactTel());
            result.setRegisteredAddress(hseCompany.getRegisterAddress());
            AreaDto areaDto = this.sysAreaService.getAreaById(hseCompany.getAreaId());
            result.setArea(areaDto);
        }
        result.setUnreadMsgNum(this.msgService.getUnreadMsgNum(userId));
        return result;
    }

    @Transactional
    public void saveUser(SaveUserCropParam param) {
        SysUser user = (SysUser)this.userService.getById(param.getId());
        if (user == null) {
            throw new ServiceException("\u67e5\u65e0\u8be5\u8d26\u53f7\u4fe1\u606f\uff01");
        }
        if (!this.userService.checkEmail(param.getEmail(), param.getId())) {
            throw new ServiceException(String.format("\u8be5\u90ae\u7bb1\u201c%s\u201d\u5df2\u88ab\u5176\u5b83\u8d26\u53f7\u7ed1\u5b9a\uff01", param.getEmail()));
        }
        user.setName(param.getName());
        user.setAreaId(param.getAreaId());
        user.setEmail(param.getEmail());
        this.updateById(user);
        param.setUserId(user.getId());
        this.sysCompanyService.saveCompany(param);
    }

    public void del(List<Long> idList, Long adminId) {
        int cropType = 2;
        this.userService.del(idList, cropType, adminId);
    }

    public void forbiddenUser(ForbiddenParam param) {
        this.userService.forbiddenUser(param);
    }

    public void resetPassword(List<Long> idList, Long adminId) {
        this.userService.resetPassword(idList, adminId);
    }

    @Transactional
    public void saveUserAndCompany(EditCropParam param) {
        this.sysCompanyService.updateCropInfo(param);
    }

    public SysUser corpImportSingleUser(CorpStafferRegisterParam corpStafferRegisterParam) {
        return this.sysUserService.corpImportSingleUser(corpStafferRegisterParam);
    }

    public List<SysUser> corpImportSingleUserList(List<CorpStafferRegisterParam> registerUserParamList) {
        return this.sysUserService.corpImportSingleUserList(registerUserParamList);
    }

    public void updateHeadImg(UpdateHeadImgParam param) {
        SysUserInfo sysUserInfo = this.userInfoService.getSysUserInfo(param.getUserId());
        SysUserInfo info = sysUserInfo.setPhotoUrl(param.getUrl());
        this.userInfoService.updateById(info);
    }

    public void companyUserRegister(RegisterCompanyUserParam companyUserParam) {
        this.userService.companyUserRegister(companyUserParam);
    }

    public SysUser registerByUsername(RegisterCompanyUserParam param) {
        return this.userService.companyUserRegisterByUsername(param);
    }

    public void genUnitAccount() {
        this.userService.genUnitAccount();
    }

    public SysUser getByCid(Long cid) {
        return this.userService.getByCid(cid);
    }

    public List<CidTokenMapVo> getListByToken(List<Long> tokenList) {
        return this.userService.getListByToken(tokenList);
    }

    public CompanyInfo getCompanyByUserId(Long userId) {
        return this.sysCompanyService.getCompanyInfo(userId);
    }

    public Set<String> getAllCompanyToken() {
        return this.userService.getAllCompanyToken();
    }

    public Object modifyCompanyFromHSE(List<CompanyModifyVo> list) {
        list.stream().forEach(modifyVo -> {
            Long uid = this.userService.updateUserByToken(this.userConverter.modifyVoToEntity(modifyVo));
            modifyVo.setUid(uid);
            this.sysCompanyService.updateCompanyByToken(this.userConverter.modifyVoToCompany(modifyVo));
        });
        return null;
    }

    public List<SysUser> getByCidList(List<Long> cidList) {
        return this.sysUserService.getByCIDList(cidList);
    }

    public SysUser selectUserByPhone(String phone) {
        return this.userService.selectUserByPhone(phone);
    }

    public SysUser getUserByToken(String token) {
        return this.userService.getUserByToken(token);
    }

    @Transactional
    public Long register(String phone, String ... args) {
        return this.userService.register(phone, args);
    }

    public void modifyPasswordByPhone(String phone, String newPassword) {
        this.userService.modifyPasswordByPhone(phone, newPassword);
    }

    public void modifyPasswordByEmail(String email, String newPassword) {
        this.userService.modifyPasswordByEmail(email, newPassword);
    }

    public void modifyEmailByLoginUserId(String email, Long userId) {
        this.userService.modifyEmailByLoginUserId(email, userId);
    }

    public void modifyPasswordByOldPwd(String phone, String oldPassword, String newPassword) {
        this.userService.modifyPasswordByOldPwd(phone, oldPassword, newPassword);
    }

    public boolean updateById(SysUser user) {
        return this.userService.updateById(user);
    }

    public LayuiGridData<UserCropListVo> getUserList(QueryUserParam param) {
        LayuiGridData<UserCropListVo> list = this.userService.getUserCropList(param);
        if (list != null && !list.getData().isEmpty()) {
            list.getData().stream().forEach(item -> item.setAreaName(this.sysAreaService.getAreaAddress(item.getAreaId(), "-")));
        }
        return list;
    }

    @Generated
    public UserCropProviderServiceImpl(ISysUserService userService, ISysUserInfoService userInfoService, ISysCompanyService sysCompanyService, IHseCompanyService hseCompanyService, ISysAreaService sysAreaService, UserToAdminDtoMap userToAdminDtoMap, UserConverter userConverter, ISysUserService sysUserService, IMsgService msgService, IHseIndustryService industryService) {
        this.userService = userService;
        this.userInfoService = userInfoService;
        this.sysCompanyService = sysCompanyService;
        this.hseCompanyService = hseCompanyService;
        this.sysAreaService = sysAreaService;
        this.userToAdminDtoMap = userToAdminDtoMap;
        this.userConverter = userConverter;
        this.sysUserService = sysUserService;
        this.msgService = msgService;
        this.industryService = industryService;
    }
}

