/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.provider.sys;

import cn.smarthse.radiationTraining.modules.sys.dao.sys.SysTestPressure1Mapper;
import cn.smarthse.radiationTraining.modules.sys.dao.sys.SysTestPressure2Mapper;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysTestPressure1;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysTestPressure2;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ITestProviderService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;

@DubboService
public class SysTestProviderServiceImpl
implements ITestProviderService {
    private final SysTestPressure1Mapper testPressure1Mapper;
    private final SysTestPressure2Mapper testPressure2Mapper;
    private static final int SUM = 3;

    public List<SysTestPressure1> testPressureV1() {
        ArrayList<SysTestPressure1> result = new ArrayList<SysTestPressure1>();
        for (int i = 0; i < 3; ++i) {
            SysTestPressure1 pressure1 = this.insertPressure1();
            SysTestPressure2 pressure2 = this.insertPressure2();
            this.updatePressure1(pressure1);
            this.updatePressure2(pressure2);
            this.testPressure1Mapper.selectById(pressure1.getId());
            result.add(pressure1);
            if (i != 2) continue;
            this.select(pressure1.getTrainName());
        }
        return result;
    }

    private void select(String name) {
        this.testPressure1Mapper.selectCount((Wrapper)Wrappers.lambdaQuery().eq(SysTestPressure1::getTrainName, (Object)name));
    }

    private void updatePressure1(SysTestPressure1 pressure) {
        pressure.setTrainName(String.format("\u538b\u529b\u6d4b\u8bd5%s", pressure.getId()));
        this.testPressure1Mapper.updateById(pressure);
    }

    private void updatePressure2(SysTestPressure2 pressure) {
        pressure.setTrainName(String.format("\u538b\u529b\u6d4b\u8bd5%s", pressure.getId()));
        this.testPressure2Mapper.updateById(pressure);
    }

    private SysTestPressure1 insertPressure1() {
        SysTestPressure1 pressure = new SysTestPressure1();
        pressure.setTrainName("\u538b\u529b\u6d4b\u8bd5");
        pressure.setTrainType("\u57f9\u8bad\u7c7b\u578b");
        pressure.setSignStarTime(new Date());
        pressure.setSignEndTime(new Date());
        pressure.setTrainStarTime(new Date());
        pressure.setTrainEndTime(new Date());
        pressure.setCoverUrl("http://www.baidu.com");
        this.testPressure1Mapper.insert(pressure);
        return pressure;
    }

    private SysTestPressure2 insertPressure2() {
        SysTestPressure2 pressure = new SysTestPressure2();
        pressure.setTrainName("\u538b\u529b\u6d4b\u8bd5");
        pressure.setTrainType("\u57f9\u8bad\u7c7b\u578b");
        pressure.setSignStarTime(new Date());
        pressure.setSignEndTime(new Date());
        pressure.setTrainStarTime(new Date());
        pressure.setTrainEndTime(new Date());
        pressure.setCoverUrl("http://www.baidu.com");
        this.testPressure2Mapper.insert(pressure);
        return pressure;
    }

    @Generated
    public SysTestProviderServiceImpl(SysTestPressure1Mapper testPressure1Mapper, SysTestPressure2Mapper testPressure2Mapper) {
        this.testPressure1Mapper = testPressure1Mapper;
        this.testPressure2Mapper = testPressure2Mapper;
    }
}

