/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.provider.sys;

import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.utils.StringUtils;
import cn.smarthse.radiationTraining.modules.sys.converter.sys.FileConverter;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysFile;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysFileProvideService;
import cn.smarthse.radiationTraining.modules.sys.service.sys.ISysFileService;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileModel;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.transaction.annotation.Transactional;

@DubboService
public class SysFileProvideServiceImpl
implements ISysFileProvideService {
    private final ISysFileService sysFileService;
    private final OssClientBean ossClientBean;
    private final FileConverter fileConverter;

    public SysFileModel getFileById(Long fileId) {
        if (fileId == null) {
            throw new ServiceException("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
        }
        SysFile sysFile = (SysFile)this.sysFileService.getById(fileId);
        if (sysFile == null) {
            return null;
        }
        sysFile.setOssUrl(this.ossClientBean.getUrl(sysFile.getOssUrl()));
        return this.toggleSysFile(sysFile);
    }

    public SysFileModel getFileByHash(String fileHash) {
        if (StringUtils.isEmpty((CharSequence)fileHash)) {
            throw new ServiceException("\u6587\u4ef6hash\u503c\u4e3a\u7a7a\uff01");
        }
        SysFile sysFile = this.sysFileService.getByHash(fileHash);
        if (sysFile == null) {
            return null;
        }
        return this.toggleSysFile(sysFile);
    }

    public String getFileUrl(Long fileId) {
        if (fileId == null) {
            return null;
        }
        SysFileModel sysFileModel = this.getFileById(fileId);
        return sysFileModel == null ? null : sysFileModel.getOssUrl();
    }

    public SysFileModel getFileUrlModel(Long fileId) {
        if (fileId == null) {
            return null;
        }
        SysFileModel sysFileModel = this.getFileById(fileId);
        SysFileModel result = new SysFileModel();
        result.setId(sysFileModel.getId());
        result.setFullOssUrl(sysFileModel.getFullOssUrl());
        return result;
    }

    public List<SysFileModel> getListByIds(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids) || ids.equals(",")) {
            return null;
        }
        List<Long> idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        return this.getListByIds(idList);
    }

    public List<SysFileModel> getListByIds(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        List list = this.sysFileService.listByIds(ids);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<SysFileModel> result = new ArrayList<SysFileModel>(list.size());
        list.stream().forEach(record -> result.add(this.toggleSysFile((SysFile)record)));
        return result;
    }

    private SysFileModel toggleSysFile(SysFile record) {
        if (record == null) {
            return null;
        }
        SysFileModel file = this.fileConverter.file2FileModel(record);
        if (file != null) {
            file.setFullOssUrl(this.ossClientBean.getUrl(file.getOssUrl()));
        }
        return file;
    }

    @Transactional(readOnly=false)
    public SysFileModel addSysFile(SysFileModel record, Long adminId) {
        SysFile sysFile = this.fileConverter.fileModel2File(record);
        sysFile.setCreateBy(adminId);
        this.sysFileService.save(sysFile);
        record.setId(sysFile.getId());
        record.setFullOssUrl(this.ossClientBean.getUrl(record.getOssUrl()));
        return record;
    }

    @Transactional
    public SysFileModel addOnlySysFile(SysFileModel record, Long adminId) {
        SysFileModel existSysFile = this.getFileByHash(record.getFileHash());
        if (existSysFile != null) {
            return existSysFile;
        }
        SysFile sysFile = this.fileConverter.fileModel2File(record);
        sysFile.setCreateBy(adminId);
        this.sysFileService.save(sysFile);
        record.setId(sysFile.getId());
        record.setFullOssUrl(this.ossClientBean.getUrl(record.getOssUrl()));
        return record;
    }

    public SysFileModel getFileByUrl(String url) {
        return null;
    }

    public List<SysFileVo> getFileVoByIds(String ids) {
        return this.sysFileService.getFileVoByIds(ids);
    }

    @Generated
    public SysFileProvideServiceImpl(ISysFileService sysFileService, OssClientBean ossClientBean, FileConverter fileConverter) {
        this.sysFileService = sysFileService;
        this.ossClientBean = ossClientBean;
        this.fileConverter = fileConverter;
    }
}

