/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.provider.hse;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseBackCompany;
import cn.smarthse.radiationTraining.modules.sys.provider.hse.IHseCompanyProviderService;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseBackCompanyService;
import cn.smarthse.radiationTraining.modules.sys.service.hse.IHseCompanyService;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;
import java.util.Date;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;

@DubboService
public class HseCompanyProviderServiceImpl
implements IHseCompanyProviderService {
    @Autowired
    private IHseCompanyService hseCompanyService;
    @Autowired
    private IHseBackCompanyService hseBackCompanyService;

    public HseCompanyVo getInfoById(Long id) {
        return this.hseCompanyService.getInfoById(id);
    }

    public List<HseCompanyVo> getInfosByIds(List<Long> ids) {
        return this.hseCompanyService.getInfosByIds(ids);
    }

    public CompanyInfo getOldStructureInfoById(Long id) {
        return this.hseCompanyService.getOldStructureInfoById(id);
    }

    public List<String> getRiskFactorByCid(Long cid) {
        return this.hseCompanyService.getRiskFactorCodesByCid(cid);
    }

    public List<String> getIndustryCodesByCid(Long cid) {
        return this.hseCompanyService.getIndustryCodesByCid(cid);
    }

    public CompanyVo getOldStructureVoById(Long id) {
        return this.hseCompanyService.getOldStructureVoById(id);
    }

    public void updateNewestInfoFromSource(Date time) {
        this.hseBackCompanyService.updateNewestORGInfoFromSourceById();
        this.hseBackCompanyService.updateNewestRayUnitInfoFromSourceById();
        this.hseBackCompanyService.updateNewestUnitInfoFromSourceById();
    }

    public void saveOrUpdateNoLogic(List<HseBackCompany> companyList) {
        if (CollectionUtil.isEmpty(companyList)) {
            return;
        }
        for (HseBackCompany hseBackCompany : companyList) {
            if (hseBackCompany.getId() != null) continue;
            throw new ServiceException("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.hseBackCompanyService.saveOrUpdateBatchNoLogic(companyList, companyList.size());
    }
}

