/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.bootstrap;

import cn.smarthse.radiationTraining.core.framework.bean.OssClientBean;
import cn.smarthse.radiationTraining.core.framework.bootstrap.BaseConfiguration;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.OssClientProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.radiationTraining.core.framework.bootstrap.properties.TaskExecutorProperties;
import cn.smarthse.radiationTraining.core.framework.utils.SpringContextHolder;
import cn.smarthse.radiationTraining.modules.sys.bootstrap.properties.EmailProperties;
import cn.smarthse.radiationTraining.modules.sys.bootstrap.properties.SmtProperties;
import java.util.Properties;
import lombok.Generated;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties(value={TaskExecutorProperties.class, SmtProperties.class, OssClientProperties.class, EmailProperties.class, SysProperties.class})
public class ContentConfiguration
extends BaseConfiguration {
    private final TaskExecutorProperties taskExecutorProperties;
    private final OssClientProperties ossClientProperties;
    private final EmailProperties emailProperties;

    @Bean(name={"ossclient"})
    public OssClientBean getOssClientBean() {
        this.logger.info("\u914d\u7f6eOssClientBean {}", (Object)this.ossClientProperties.getOss_bucketname());
        OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setLocal(this.ossClientProperties.getOss_local());
        ossClientBean.setDomain(this.ossClientProperties.getDomain());
        ossClientBean.setEndpoint(this.ossClientProperties.getOss_endpoint());
        ossClientBean.setAccessKeyId(this.ossClientProperties.getOss_accesskey());
        ossClientBean.setAccessKeySecret(this.ossClientProperties.getOss_accesssecret());
        ossClientBean.setBucketName(this.ossClientProperties.getOss_bucketname());
        ossClientBean.setAsynch(this.ossClientProperties.isOss_asynch());
        ossClientBean.setPublicread(this.ossClientProperties.isPublicread());
        ossClientBean.setExptime(this.ossClientProperties.getExptime());
        return ossClientBean;
    }

    @Bean(value={"emailTemplate"})
    public JavaMailSenderImpl getJavaMailSenderImpl() {
        this.logger.info("\u914d\u7f6e JavaMailSenderImpl {}", (Object)this.emailProperties);
        JavaMailSenderImpl emailTemplate = new JavaMailSenderImpl();
        emailTemplate.setDefaultEncoding(this.emailProperties.getDefault_encoding());
        emailTemplate.setHost(this.emailProperties.getHost());
        emailTemplate.setPort(this.emailProperties.getPort());
        emailTemplate.setUsername(this.emailProperties.getUsername().trim().split(",")[0]);
        emailTemplate.setPassword(this.emailProperties.getPassword().trim().split(",")[0]);
        Properties javaMailProperties = new Properties();
        javaMailProperties.setProperty("mail.smtp.auth", "true");
        javaMailProperties.setProperty("mail.smtp.timeout", "25000");
        javaMailProperties.put("mail.smtp.starttls.enable", (Object)true);
        javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        emailTemplate.setJavaMailProperties(javaMailProperties);
        return emailTemplate;
    }

    @Bean
    public ThreadPoolTaskExecutor taskExecutor() {
        this.logger.info("\u914d\u7f6eThreadPoolTaskExecutor");
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix(this.taskExecutorProperties.getThreadNamePrefix());
        executor.setCorePoolSize(this.taskExecutorProperties.getCore_pool_size());
        executor.setMaxPoolSize(this.taskExecutorProperties.getMax_pool_size());
        executor.setQueueCapacity(this.taskExecutorProperties.getQueue_capacity());
        executor.setKeepAliveSeconds(this.taskExecutorProperties.getKeep_alive_seconds());
        executor.setRejectedExecutionHandler((r, executor1) -> this.logger.error("\u7ebf\u7a0b\u6c60\u5df2\u6ee1\uff0c\u7ebf\u7a0b\u62d2\u7edd\u6267\u884c\uff1a{}", (Object)r.toString()));
        executor.initialize();
        return executor;
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    @Generated
    public ContentConfiguration(TaskExecutorProperties taskExecutorProperties, OssClientProperties ossClientProperties, EmailProperties emailProperties) {
        this.taskExecutorProperties = taskExecutorProperties;
        this.ossClientProperties = ossClientProperties;
        this.emailProperties = emailProperties;
    }
}

