/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;

@JsonFormat(shape=JsonFormat.Shape.OBJECT)
public enum OrderPayStateEnum {
    UN_PAY("\u5f85\u652f\u4ed8", 1),
    PAY("\u5df2\u652f\u4ed8", 2),
    CANCEL_PAY("\u5df2\u53d6\u6d88", 3),
    REFUND("\u5df2\u9000\u6b3e", 4),
    APPLY_REFUND("\u7533\u8bf7\u9000\u6b3e", 5),
    FAIL_REFUND("\u9000\u6b3e\u5931\u8d25", 6);

    private String name;
    private Integer value;

    private OrderPayStateEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isPay(Integer value) {
        if (value == null) {
            return false;
        }
        if (value.equals(OrderPayStateEnum.PAY.value)) return true;
        if (!value.equals((Object)APPLY_REFUND)) return false;
        return true;
    }

    public static String getName(Integer value) {
        if (value == null) {
            return null;
        }
        for (OrderPayStateEnum c : OrderPayStateEnum.values()) {
            if (!c.getValue().equals(value)) continue;
            return c.name;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }
}

