package cn.smarthse.radiationTraining.modules.sys.vo.user;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 个人用户-列表
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/11 15:58
 */
//@ApiModel
@Data
public class UserListVo implements Serializable {

    private static final long serialVersionUID = 8777051574469270668L;

    //@ApiModelProperty("id")
    private Long id;

    @Desensitization(type = DesensitizationType.NAME)
    //@ApiModelProperty("账号")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String username;

    @Desensitization(type = DesensitizationType.EMAIL)
    //@ApiModelProperty("邮箱")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String email;

    @Desensitization(type = DesensitizationType.ID_CARD)
    //@ApiModelProperty("身份证")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String idcard;

    //@ApiModelProperty("培训次数")
    private Integer trainingTimes;

    //@ApiModelProperty("注册来源（1-注册；2-企业导入）")
    private Integer resource;

    @Desensitization(type = DesensitizationType.NAME)
    //@ApiModelProperty("姓名")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    //@ApiModelProperty("角色")
    private String roleName = "平台普通用户";

    //@ApiModelProperty(value = "是否是放射工作人员")
    private Integer isRayWork;

    //@ApiModelProperty(value = "是否为测试账号(0否 1是)")
    private Integer isTest;

    //@ApiModelProperty("账号创建时间")
    private Date createDate;

    //@ApiModelProperty("是否禁用（1-禁用；0-启用）")
    private Boolean isForbidden;
}
