package cn.smarthse.radiationTraining.modules.sys.vo.user;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 个人用户-详情
 *
 * @author wuxq
 * @date 2022/3/15 9:58
 */
@Accessors(chain = true)
//@ApiModel
@Data
public class PersonalUserVoH5 implements Serializable {

    private static final long serialVersionUID = 8137949821209197983L;

    //@ApiModelProperty("id")
    private Long id;

    //@ApiModelProperty(value = "用户类型(1-个人；2-单位；3-机构；4-医院) SysUserTypeEnum")
    private Integer userType = 1;

    //@ApiModelProperty(value = "姓名", required = true)
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    //@ApiModelProperty("账号")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String username;

    //@ApiModelProperty("手机号")
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String phone;

    //@ApiModelProperty(value = "邮箱", required = true)
    @Desensitization(type = DesensitizationType.EMAIL)
    private String email;

    //@ApiModelProperty(value = "身份证号", required = true)
    @Desensitization(type = DesensitizationType.ID_CARD)
    private String idcard;

    //@ApiModelProperty(value = "证件号类型", required = true)
    private Integer idcardType;

    //@ApiModelProperty(value = "证件号类型", required = true)
    private String idcardTypeName;

    //@ApiModelProperty(value = "身份证修改剩余次数", required = true)
    private Integer residueIdcardLimit;

    //@ApiModelProperty(value = "性别（1-男；0-女）")
    private Integer sex;

    //@ApiModelProperty("是否为测试账号（0否 1是）")
    private Integer isTest;

    //@ApiModelProperty(value = "头像url")
    private String avatar;

    //@ApiModelProperty(value = "证件照url")
    private String photoUrl;

    //@ApiModelProperty(value = "学历")
    private String education;
    //@ApiModelProperty(value = "学历")
    private String educationStr;

    //@ApiModelProperty(value = "工作类别")
    private String workType;
    //@ApiModelProperty(value = "工作类别")
    private String workTypeStr;

    //@ApiModelProperty(value = "放射工作开始时间")
    private Date radiationWorkDate;

    //@ApiModelProperty(value = "单位id")
    private Long companyId;

    //@ApiModelProperty(value = "单位名称", required = true)
    private String companyNname;

    //@ApiModelProperty(value = "社会信用代码", required = true)
    private String creditCode;

    //@ApiModelProperty(value = "行政区划", required = true)
    private Long areaId;

    //@ApiModelProperty(value = "详细注册地址", required = true)
    private String addressDetail;

    //@ApiModelProperty(value = "完整的注册地址", hidden = true)
    private String fullAddress;

    //@ApiModelProperty("总消息条数")
    private Integer totalMsgNum;

    //@ApiModelProperty("未读消息条数")
    private Integer unreadMsgNum;

    //@ApiModelProperty("是否为简略信息")
    private Boolean isBrief;
}
