
package cn.smarthse.radiationTraining.modules.sys.vo.order;

import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayStateEnum;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 用户订单
 *
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
public @Data
class UserOrderVo implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     *  系统订单号
     */
    private Long id;

    /**
     *  支付宝订单号
     */
    private String orderNo;

    /**
     *  商品id
     */
    private Long goodsId;

    /**
     *  商品名称
     */
    private String subject;

    /**
     *  付费类型(1-线上支付; 2-线下支付；3-赠送)
     */
    private Integer payType;

    /**
     *  付费类型(1-线上支付; 2-线下支付；3-赠送)
     */
    private String payTypeStr;

    /**
     *  支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）
     */
    private Integer payState;

    /**
     *  支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）
     */
    private String payStateStr;

    /**
     *  商品总额
     */
    private BigDecimal goodsPrice;

    /**
     *  实付款
     */
    private BigDecimal payMoney;

    /**
     *  下单时间
     */
    private LocalDateTime createDate;


    public String getPayTypeStr() {
         //付费类型(1-线上支付; 2-线下支付；3-赠送)
        return OrderPayTypeEnum.getName(this.payType);
    }

    public String getPayStateStr() {
        //支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）
        return OrderPayStateEnum.getName(this.getPayState());
    }

}
