
package cn.smarthse.radiationTraining.modules.sys.vo.order;

import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayStateEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 订单
 *
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
public @Data class UserOrderModel implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 系统订单号
     */
    private Long id;

    /**
     * 关联账号id
     */
    private Long userId;

    /**
     * 关联账号
     */
    private String username;

    /**
     * 关联商品id
     */
    private Long goodsId;

    /**
     * 支付宝微信订单号
     */
    private String orderNo;

    /**
     * 商品单价
     */
    private BigDecimal unitPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 商品名称
     */
    private String subject;

    /**
     * 支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）
     */
    private Integer payState;

    /**
     * 支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）
     */
    private String payStateStr;

    /**
     * 三方支付类型（1-微信；2-支付宝）
     */
    private Integer thirdPayType;

    /**
     * 商品总额
     */
    private BigDecimal goodsPrice;

    /**
     * 实付款
     */
    private BigDecimal payMoney;


    /**
     * 下单时间
     */
    private LocalDateTime createDate;

    public String getPayStateStr() {
        //支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）
        return OrderPayStateEnum.getName(this.getPayState());
    }

}
