
package cn.smarthse.radiationTraining.modules.sys.vo.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 订单退款记录Vo
 *
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
public @Data class SysOrderRefundVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 三方订单号
     */
    private String tradeNo;

    /**
     * 三方支付方式 OrderThirdPayTypeEnum(微信支付-1; 支付宝支付-2)
     */
    private Integer thirdPayType;

    /**
     * 订单操作状态OR类型(1-退款成功; 2-退款失败/异常；3-申请退款；4-拒绝退款)
     */
    private Integer state;

    /**
     * 原订单金额
     */
    private BigDecimal totalAmount;

    /**
     * 退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 退款原因说明
     */
    private String refundReason;

    /**
     * 退款失败原因
     */
    private String failReason;

    /**
     * 退款操作人id
     */
    private Long refundAdminId;

    /**
     * 退款操作人
     */
    private String refundAdmin;

    /**
     * 操作时间
     */
    private LocalDateTime createDate;

}
