
package cn.smarthse.radiationTraining.modules.sys.vo.order;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单退款 审核页详情
 *
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
public @Data class SysOrderRefundAuditVo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 订单退款id
     */
    private Long orderRefundId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 退款人id
     */
    private Long userId;

    /**
     * 操作账号
     */
    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String operatorName;

    /**
     * 退款金额
     */
    private BigDecimal refundAmount;

    /**
     * 退款状态（1-退款成功; 2-退款失败/异常；3-申请退款；4-拒绝退款）
     */
    private Integer state;

    /**
     * 退款申请时间
     */
    private Date refundApplyTime;

    /**
     * 退款申请通过时间
     */
    private Date refundPassTime;

    /**
     * 退款申请失败时间
     */
    //private Date refundFailTime;

}
