package cn.smarthse.radiationTraining.modules.sys.vo.order;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderPayStateEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 订单
 *
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
public @Data
class SysOrderModel implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 系统订单号（id）
     */
    private Long id;

    /**
     * 支付宝订单号
     */
    private String orderNo;

    /**
     * 关联账号id
     */
    private Long userId;

    /**
     * 关联账号
     */

    @Desensitization(type = DesensitizationType.MOBILE_PHONE)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String username;

    /**
     * 关联商品id
     */
    private Long goodsId;

    /**
     * 商品名称
     */
    private String subject;

    /**
     * 商品单价
     */
    private BigDecimal unitPrice;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 商品总额
     */
    private BigDecimal goodsPrice;

    /**
     * 实付款
     */
    private BigDecimal payMoney;

    /**
     * 付款时间
     */
    private LocalDateTime payDate;

    /**
     * 付款人
     */
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String nickname;

    /**
     * 付款人所在单位
     */
    private String companyName;

    /**
     * 支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）；4-已退款; 5-申请退款
     */
    private Integer payState;

    /**
     * 支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）；4-已退款; 5-申请退款
     */
    private String payStateStr;

    /**
     * 创建时间
     */
    private Date startExamTime;

    /**
     * 创建时间
     */
    private Date createDate;

    public Integer getPayState() {

        if (this.payState == null) {
            return 0;
        }

        return this.payState;
    }

    public String getPayStateStr() {
        //支付状态：1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）); 4-已退款; 5-申请退款
        return OrderPayStateEnum.getName(this.getPayState());
    }
}
