package cn.smarthse.radiationTraining.modules.sys.vo.hse;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 企业信息
 * @TableName company
 */
@Accessors(chain = true)
@Data
public class HseCompanyVo implements Serializable {

    //@ApiModelProperty("ID")
    private Long id;

    //@ApiModelProperty("fullname企业名称")
    private String name;

    //@ApiModelProperty("企业类型（1-有人单位,2-外包单位）")
    private Integer companyType;

    //@ApiModelProperty("是否是测试企业")
    private Boolean isTest;

    //@ApiModelProperty("企业名称简称")
    private String shortName;

    //@ApiModelProperty("上属公司（主管单位）")
    private String fatherDept;

    //@ApiModelProperty("成立时间")
    private Date settingTime;

    //@ApiModelProperty("统一社会信用代码")
    private String unifiedSocialCc;

    //@ApiModelProperty("顺序码")
    private Integer seq;

    //@ApiModelProperty("信用代码状态（0默认， 2信用代码错误）")
    private Integer socialCcState;

    //@ApiModelProperty("corp_tel 企业联系电话")
    private String companyContactTel;

    //@ApiModelProperty("corp_email 企业电子邮箱")
    private String companyContactEmail;

    //@ApiModelProperty("企业传真")
    private String companyContactFax;

    //@ApiModelProperty("corp_area_id 行政区域区编号")
    private Long areaId;

    //@ApiModelProperty("监督单位")
    private Long supervisionUnit;

    //@ApiModelProperty("监督单位区域")
    private Long supervisionAreaId;

    //@ApiModelProperty("企业注册地详址")
    private String registerAddress;

    //@ApiModelProperty("企业注册地址邮编")
    private String registerPost;

    //@ApiModelProperty("corp_address 企业通讯地址")
    private String companyPostalAdress;

    //@ApiModelProperty("工作产所地址（工作场所地址）")
    private String workAddress;

    //@ApiModelProperty("")
    private Long registerType;

    //@ApiModelProperty("corp_type 行业分类（sys_param.param_code）")
    private Long industryCategory;

    //@ApiModelProperty("职业病危害风险分类（0-严重、1-较重、2-一般")
    private Integer occupationalRiskClassify;

    //@ApiModelProperty("在岗职工人数")
    private Integer staffCount;

    //@ApiModelProperty("接害人数（不重复计）")
    private Integer pickupCount;

    //@ApiModelProperty("主营营业收入（万元）")
    private BigDecimal mainOperaIncome;

    //@ApiModelProperty("注册资本")
    private BigDecimal registerCapital;

    //@ApiModelProperty("企业规模")
    private String scale;

    //@ApiModelProperty("企业年度产值")
    private BigDecimal yearAssets;

    //@ApiModelProperty("企业资产总值")
    private BigDecimal totalAssets;

    //@ApiModelProperty("法人代表姓名")
    private String legalName;

    //@ApiModelProperty("法人代表联系电话")
    private String legalTel;

    //@ApiModelProperty("化学事故应急咨询服务电话")
    private String chemicalEmergencyPhone;

    //@ApiModelProperty("职业卫生负责人")
    private Long occLeaderSid;

    //@ApiModelProperty("职业卫生负责人联系电话")
    private String occLeaderTel;

    //@ApiModelProperty("职业卫生管理人员")
    private String occManagerName;

    //@ApiModelProperty("ְ管理人员手机号码")
    private String occManagerTel;

    //@ApiModelProperty("企业主要负责人")
    private String mainLeaderName;

    //@ApiModelProperty("负责人手机号码")
    private String mainLeaderTel;

    //@ApiModelProperty("创建时间")
    private Date createDate;
    //@ApiModelProperty("直属企业类型：0非直属，1省直属，2市属")
    private Integer belongType;

    //@ApiModelProperty("同步来源(1职业健康在线  2职业健康在线机构 3放射卫生在线医院)")
    private Integer syncSourceType;

    private static final long serialVersionUID = 1L;

    public String getCreditCode(){
        return seq == null || seq == 0 ? unifiedSocialCc : unifiedSocialCc + "-" + seq;
    }
}