
package cn.smarthse.radiationTraining.modules.sys.provider.web;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.QueryArticleParam;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.SaveArticleIsTopParam;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.SaveArticleParam;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.SaveArticleUpOrDownParam;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleApiVo;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleVo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 网站-文章 service
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/10 17:02
 */
public interface IArticleProviderService {

    /**
     * 查询信息资讯列表-首页(宣传栏的)
     *
     * @return {@link List<ArticleListVo>}
     * @author liaoly
     * @date 2022/3/11 9:47
     */
    List<ArticleListVo> getHomeArticleList();

    /**
     * 查询信息资讯列表-首页-资讯栏的
     *
     * @return {@link HashMap<String, List<ArticleListVo>>}
     * @author liaoly
     * @date 2022/3/24 10:21
     */
    Map<String, List<ArticleListVo>> getHomeArticleList2();

    /**
     * 查询信息资讯列表-资讯模块的-置顶
     *
     * @return {@link List<ArticleListVo>}
     * @author liaoly
     * @date 2022/3/24 10:21
     */
    List<ArticleListVo> getTopArticleList();

    /**
     * 查询信息资讯列表-分页
     *
     * @param param 分页查询参数
     * @return {@link LayuiGridData<ArticleListVo>}
     * @author liaoly
     * @date 2022/3/11 9:47
     */
    LayuiGridData<ArticleListVo> getArticleList(QueryArticleParam param);

    /**
     * 查询信息资讯详情
     *
     * @param id - 资讯id
     * @return {@link ArticleVo}
     * @author liaoly
     * @date 2022/3/11 9:48
     */
    ArticleVo getArticle(Long id);

    /**
     * WWW: 查询信息资讯详情
     *
     * @param id - 资讯id
     * @return {@link ArticleApiVo}
     * @author liaoly
     * @date 2022/3/11 9:48
     */
    ArticleApiVo getArticleApi(Long id);

    /**
     * 资讯动态-保存
     *
     * @param param 参数
     * @author liaoly
     * @date 2022/3/11 10:21
     */
    void saveArticle(SaveArticleParam param);

    /**
     * 资讯动态-置顶操作
     *
     * @param param 参数
     * @author liaoly
     * @date 2022/3/11 10:21
     */
    void saveIsTop(SaveArticleIsTopParam param);

    /**
     * 资讯动态-上下架操作
     *
     * @param param -
     * @author liaoly
     * @date 2022/3/11 10:28
     */
    void saveUpOrDown(SaveArticleUpOrDownParam param);

    /**
     * 资讯动态-删除(1-下架、0-草稿状态的才能删除)
     *
     * @param idList 文章id集合
     * @author liaoly
     * @date 2022/3/11 10:29
     */
    void del(List<Long> idList);

    /**
     * 更新资讯动态点击量
     *
     * @param id            文章id
     * @param increaseClick 点击量增量
     * @author liaoly
     * @date 2022/3/24 15:01
     */
    void updateClick(Long id, int increaseClick);
}
