package cn.smarthse.radiationTraining.modules.sys.provider.user;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.dto.user.UserToAdminDto;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.param.ForbiddenParam;
import cn.smarthse.radiationTraining.modules.sys.param.user.*;
import cn.smarthse.radiationTraining.modules.sys.param.user.uc.EditUserParam;
import cn.smarthse.radiationTraining.modules.sys.vo.user.PersonalUserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserListVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.HSEUserInfoVo;

import java.util.List;

/**
 * 个人账号-dubbo服务
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2022/2/16 20:51
 */
public interface IUserProviderService {

    /**
     * 查询用户中心-账号信息
     *
     * @param userId : 账号id
     * @return cn.doubi.learn.modules.user.dto.user.UserToAdminTdo
     * @author liaoly
     * @date 2022/2/16 20:55
     */
    UserToAdminDto getUserDto(Long userId);

    /**
     * 根据手机号查询用户
     *
     * @param phone phone
     * @return User
     */
    SysUser selectUserByPhone(String phone);

    /**
     * 查询用户信息
     *
     * @param token 匹配账号、手机号、邮箱
     * @return User
     */
    SysUser getUserByToken(String token);

    /**
     * 查询用户信息
     *
     * @param token 匹配账号、手机号、邮箱
     * @param userType 用户类型(1-个人；2-单位；3-机构；4-医院) SysUserTypeEnum
     * @return User
     */
    SysUser getUserByToken(String token, Integer userType);

    /**
     * 根据账号名查询账号
     *
     * @param username 账号
     * @param userType 用户类型(1-个人；2-单位；3-机构；4-医院) SysUserTypeEnum
     * @return User
     */
    SysUser getUserByUsername(String username, Integer userType);
    /**
     * 根据手机号名查询账号
     *
     * @param phone 手机号
     * @return User
     */
    SysUser getUserByPhone(String phone);
    SysUser getUserById(Long id);

    SysUser getFullUserInfoById(Long userId);

    /**
     * 根据令牌Token查询单位账号信息 (userType=2)
     * @param token 令牌Token 职业健康在线单位的cid
     * @return {@link SysUser}
     * @author liaoly
     * @date 2022/8/17 9:00
     */
    SysUser getCompanyUserByToken(Long token);

    /**
     * 根据id查询用户
     *
     * @param userId userId
     * @return User
     */
    SysUser selectUserById(Long userId);

    /**
     * 用户注册,默认密码为手机号后六位
     *
     * @param phone phone
     * @param args  密码
     * @return userId
     */
    Long register(String phone, String... args);

    /**
     * 修改密码-by 手机号
     *
     * @param phone       手机号
     * @param newPassword 密码
     */
    void modifyPasswordByPhone(String phone, String newPassword);

    /**
     * 修改密码-by 邮箱
     *
     * @param email       邮箱
     * @param newPassword 密码
     */
    void modifyPasswordByEmail(String email, String newPassword);

    /**
     * 输入旧密码修改密码
     *
     * @param phone       手机号
     * @param oldPassword 旧密码
     * @param newPassword 新密码
     */
    void modifyPasswordByOldPwd(String phone, String oldPassword, String newPassword);

    /**
     * 输入旧密码修改密码
     *
     * @param userId      账号id
     * @param oldPassword 旧密码
     * @param newPassword 新密码
     */
    void modifyPasswordByOldPwd(Long userId, String oldPassword, String newPassword);

    /**
     * 更新操作
     *
     * @param user :
     * @return boolean
     * @author liaoly
     * @date 2022/2/17 22:12
     */
    boolean updateById(SysUser user);

    /**
     * 个人账号-列表
     *
     * @param param param
     * @return {@link List<UserListVo>}
     * @author liaoly
     * @date 2022/3/11 16:03
     */
    LayuiGridData<UserListVo> getUserList(QueryUserParam param);

    /**
     * 查询用户中心-账号信息
     *
     * @param userId 账号id
     * @return {@link UserVo}
     * @author liaoly
     * @date 2022/3/7 13:13
     */
    UserVo getUserVo(Long userId);

    /**
     * 个人账号-编辑
     *
     * @param param -
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2022/3/11 15:12
     */
    void saveUser(SaveUserParam param);

    /**
     * 个人账号-删除
     *
     * @param idList  账号id集合
     * @param adminId 操作账号id
     * @author liaoly
     * @date 2022/3/11 15:16
     */
    void del(List<Long> idList, Long adminId);

    /**
     * 个人账号-禁用、启用
     *
     * @param param 参数
     * @author liaoly
     * @date 2022/3/11 15:28
     */
    void forbiddenUser(ForbiddenParam param);

    /**
     * 个人账号-重置密码(默认密码为“123456”)
     *
     * @param idList  账号id集合
     * @param adminId 操作账号id
     * @author liaoly
     * @date 2022/3/11 15:18
     */
    void resetPassword(List<Long> idList, Long adminId);

    /**
     * 方法描述:  个人用户注册
     *
     * @param   userParam 参数对象
     * @return  void
     * @author  wuxq
     * @date    2022/3/15
     */
    SysUser personalUserRegister(RegisterUserParam userParam);

    SysUser personalUserRegisterForXh(RegisterXhUserParam userParam);

    /**
     * 给证书导入创建用户账号
     *
     * @param   userParamList 参数对象
     * @return  void
     * @author  chuhy
     * @date    2023/8/15
     */
    void createUserForImport(List<RegisterUserParam> userParamList);

    /**
     * 通过邮件获取用户信息
     * @param email
     * @return SysUser
     */
    SysUser getOneByEmail(String email);
    /**
     * 通过身份证获取获取用户
     * @param idCard
     * @return
     */
    SysUser getOneByIdCard(String idCard);
    /**
     * 方法描述:  个人中心-编辑
     *
     * @param   editUserParam 参数对象
     * @return  void
     * @author  wuxq
     * @date    2022/3/18
     */
    void editPersonal(EditUserParam editUserParam);

    void editXhPersonal(EditUserParam editUserParam);
    /**
     * 方法描述:  个人用户中心
     *
     * @param   loginUserId 当前登录id
     * @return  PersonalUserVo
     * @author  wuxq
     * @date    2022/3/24
     */
    PersonalUserVo getPersonalUserInfo(Long loginUserId);

    /**
     * 修改密码--导入后未修改密码的
     * @param userId 账号id
     * @param password 密码
     * @author liaoly
     * @date 2022/3/25 15:27
     */
    void modifyPassword(Long userId, String password);

    /**
     * 查询证件照
     * @param userId 用户id
     * @return {@link String}
     * @author liaoly
     * @date 2022/4/28 18:13
     */
    String getPhotoUrl(Long userId);

    /**
     * 方法描述:  更新头像
     *
     * @param   param
     * @return  void
     * @author  wuxq
     * @date    2022/5/30
     */
    void updateHeadImg(UpdateHeadImgParam param);

    /**
     * @description 对应职业健康系统得信息
     * @param loginUserId
     * @return cn.smarthse.radiationTraining.modules.sys.vo.user.info.HSEUserInfoVo
     * @author chenliang
     * @date 2022/10/11 09:52:35
     */
    HSEUserInfoVo getHSEPersonalInfo(Long loginUserId,String idcard,String name);

    /**
     * @description 获取报名次数
     * @param uid
     * @return java.lang.Integer
     * @author chenliang
     * @date 2022/10/13 14:24:29
     */
    Integer getEnrollTime(Long uid);

    void ifCanEditPersonalUserBatch(List<Long> list,String loginUsername, Integer userType,Integer optUserRole, Long superviseArea);

    /**
     * 判断个人用户是否可以被删除
     * @param idList 用户id列表
     * @param loginUsername 操作账号
     * @param userFrom 操作账号类型
     * @author chenliang
     * @date 2022/12/29 13:15
     */
    void ifCanRmForPersonal(List<Long> idList, String loginUsername, Integer userFrom, Integer useOptRole);

    /**
     * @description 定时任务设置账号每90天修改密码
     * @author zhangxu
     * @date 2023/1/11
     */
    void changePasswordRegularly();

    /**
     * 对已报名的单位但还没有账号的单位生成账号；
     * 可指定单位cid，若为空则生成50条
     * @param cid 公司id
     * @author chuhy
     * @date 2023/6/2 14:26
     */
    void manuallyGenUnitAccount(Long cid);

    /**
     * 根据浙里办userId查询账号
     * @param zlbUserId 浙里办userId
     * @author liaoly
     * @date 2023/6/28 8:45
     */
    SysUser getUserByZlbUserId(String zlbUserId);

    /**
     * 绑定浙里办userId
     * @param userId 账号id
     * @param zlbUserId 浙里办userId
     * @author liaoly
     * @date 2023/9/6 16:21
     */
    void bindZlbUserId(Long userId, String zlbUserId);
    /**
     * 更新身份证信息
     * @param userId 账号id
     * @param name 姓名
     * @param idcard 身份证id
     * @author liaoly(廖凌云)
     * @date 2023/10/25 13:48
     */
    void updateIdcard(Long userId, String name, String idcard, Integer idcardType, Long areaId);

    /**
     * 查询所有个人用户
     * @return {@link java.util.List<java.lang.Long>}
     * @author chuhy
     * @date 2023/11/21 13:20
     */
    List<Long> listAllWxUserId();

    /**
     * 查询前缀相同的账号数量
     * @param usernamePrefix 前缀 姓名字母缩写+后6位省份证
     * @return {@link int}
     * @author liaoly(廖凌云) [1302013247@qq.com]
     * @date 2024/1/18 16:56
     */
    long getSameUsernameCount(String usernamePrefix);

    /**
     * zlb更新后更新手机号
     * @param id
     * @param phone
     */
    void updatePhoneForZlb(Long id, String phone);
}
