package cn.smarthse.radiationTraining.modules.sys.provider.user;

import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.shiro.UserInfo;

/**
 * 用户信息dubbo服务
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2022/2/16 20:51
 */
public interface IUserInfoProviderService {

    /**
     * 查询个人账号的个人信息
     * @author liaoly
     * @date 2022/3/9 12:19
     * @param userId
     * @return {@link UserInfo}
     */
    UserInfo getUserInfo(Long userId);

    /**
     * 查询企业账号的企业信息
     * @author liaoly
     * @date 2022/3/9 12:19
     * @param userId
     * @return {@link CompanyInfo}
     */
    CompanyInfo getCompanyInfo(Long userId);
}
