package cn.smarthse.radiationTraining.modules.sys.provider.sys;


import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysOccupationalHazards;
import cn.smarthse.radiationTraining.modules.sys.param.sys.OccHazardsQueryParam;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.OccHazardsVo;

import java.util.List;
import java.util.Map;

public interface ISysOccupationalHazardsProviderService {

    /**
     * 方法描述:  获取所有危害因素
     */
    List<SysOccupationalHazards> getAllHazards();

    /**
     * 方法描述:  根据名称查询
     */
    SysOccupationalHazards getByName(String name);

    /**
     * 方法描述:  根据危害因素代码查询
     */
    SysOccupationalHazards getByCode(String code);
    List<SysOccupationalHazards> getByCodes(List<String> codes);

    /**
     * 名称->代码
     */
    Map<String, String> nameToCodeMap();

    /**
     * 方法描述:   根据code查询危害因素等级
     */
    Integer getHazardsLevel(String hazardsCode);

    /**
     * 方法描述:   根据codes查询危害因素名称
     */
    List<String> getNamesByCodes(List<String> typeIds);

    /**
     * 获取危害因素名称
     * @param codeStr 危害因素代码，用逗号分割
     * @return 危害因素名称,用逗号分隔
     */
    String getNameStrByCodeStr(String codeStr);

    /**
     * 方法描述:   根据危害因素名称查询codes
     */
    String getCodesByNames(List<String> typeNames);

    /***
     * @description 分页查询
     * @param param
     * @return
     * @author chenliang
     * @date 2022/8/10 14:53:39
     */
    LayuiGridData<OccHazardsVo> queryPage(OccHazardsQueryParam param);

    /***
     * @description 查询树
     * @param param
     * @return
     * @author chenliang
     * @date 2022/8/10 14:53:50
     */
    List<OccHazardsVo> queryTree(OccHazardsQueryParam param);

    /**
     * @description 获取后代节点数量
     * @param code
     * @return java.lang.Integer
     * @author chenliang
     * @date 2022/8/15 08:43:10
     */
    Long getProgenyNum(String code,Integer level);
}
