package cn.smarthse.radiationTraining.modules.sys.provider.sys;

import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompanyStaff;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyListVo;

import java.util.List;

/**
 * @description 公司员工关系模块远程服务
 * @author chenliang
 * @date 2022/10/8 09:45:27
 */
public interface ISysCompanyStaffProviderService {
    /**
     * @description 建立公司员工关系表
     * @param cid 公司id
     * @param uid 用户id
     * @param loginUserId 操作人
     * @return void
     * @author chenliang
     * @date 2022/10/8 09:53:53
     */
    void save(Long cid, Long uid, Long loginUserId);

    /***
     * @description 删除所有联系
     *
     * @return void
     * @author chenliang
     * @date 2022/10/10 13:59:55
     */
    void removeAll(String pwd);
    /***
     * @description 根据uid获取关联信息
     *
     * @return void
     * @author chenliang
     * @date 2022/10/10 13:59:55
     */
    List<SysCompanyStaff> getByUID(Long uid);

    /**
     * @description 建立公司员工关系表
     * @param cid 公司id
     * @param uid 用户id
     * @param loginUserId 操作人
     * @param source 来源(1-培训；2-卫企学习)
     * @return void
     */
    void saveWithSource(Long cid, Long uid, Long loginUserId, Integer source);

    /***
     * 查找用户id关联的公司信息
     * @param uid 用户id
     * @param source 来源(1-培训；2-卫企学习)
     * @return void
     * @author chuhy
     * @date 2022/10/10 13:59:55
     */
    List<CompanyListVo> getByUidAndSource(Long uid, Integer source);

    /***
     * 查找用户id关联的公司信息-提供给自主报名
     * @param uid 用户id
     * @param source 来源(1-培训；2-卫企学习)
     * @return void
     * @author chuhy
     * @date 2022/10/10 13:59:55
     */
    List<CompanyListVo> getByUidForSelfEnroll(Long uid, Integer source);

    /***
     * 查找用户id最近一次关联的公司信息
     * @param uid 用户id
     * @param source 来源(1-培训；2-卫企学习)
     * @return void
     * @author chuhy
     * @date 2022/10/10 13:59:55
     */
    CompanyListVo getNewestByUidAndSource(Long uid, Integer source);

}
