package cn.smarthse.radiationTraining.modules.sys.provider.sys;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.sys.param.sys.CheckAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.QueryAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveAppVersionParam;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CheckAppVersionVo;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysAppVersionVo;

public interface ISysAppVersionProviderService {
    /**
     * @description 多条件分页查询
     * @param param
     * @return cn.smarthse.radiationTraining.core.framework.model.LayuiGridData<cn.smarthse.radiationTraining.modules.sys.vo.sys.SysAppVersionVo>
     * @author chenliang
     * @date 2022/9/22 17:01:28
     */
    LayuiGridData<SysAppVersionVo> search(QueryAppVersionParam param);
    /**
     * @description 添加或更新app版记录
     * @param param
     * @return void
     * @author chenliang
     * @date 2022/9/22 15:57:21
     */
    void addOrUpVersion(SaveAppVersionParam param);


    /**
     * @description 根据id删除数据
     * @param id
     * @return void
     * @author chenliang
     * @date 2022/9/23 13:20:24
     */
    void deleteVersion(Long id);

    /**
     * @description 检查app版本
     * @param param
     * @return cn.smarthse.radiationTraining.modules.sys.vo.sys.CheckAppVersionVo
     * @author chenliang
     * @date 2022/9/22 15:57:45
     */
    CheckAppVersionVo checkUserAppVersion(CheckAppVersionParam param);

    /**
     * @description 获取当前版本
     * @param version
     * @param type
     * @return cn.smarthse.radiationTraining.modules.sys.entity.sys.SysAppVersion
     * @author chenliang
     * @date 2022/9/22 15:59:12
     */
    SysAppVersionVo getCurrVersion(String version, Integer type);

    /**
     * @description 获取最新的、需要强制更新的版本
     * @param type
     * @return cn.smarthse.radiationTraining.modules.sys.entity.sys.SysAppVersion
     * @author chenliang
     * @date 2022/9/22 15:59:24
     */
    SysAppVersionVo getNewestOfForcedUpdatingVersion(Integer type);

    /**
     * @description 获取最新版本
     * @param type
     * @return cn.smarthse.radiationTraining.modules.sys.entity.sys.SysAppVersion
     * @author chenliang
     * @date 2022/9/22 15:59:50
     */
    SysAppVersionVo getNewest(Integer type);
}
