package cn.smarthse.radiationTraining.modules.sys.provider.sys;

import cn.smarthse.radiationTraining.modules.sys.dto.sys.SysAreaDto;
import cn.smarthse.radiationTraining.modules.sys.dto.sys.SysAreaTreeDto;

import java.util.List;

/**
 * 首页可视化
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2022/2/16 21:05
 */
public interface IAreaProviderService {

	/**
	 * 查询行政区划
	 * @author liaoly
	 * @date 2022/2/16 21:08
	 * @param areaId :
	 * @return cn.doubi.learn.modules.sys.dto.AreaDto
	 */
	public SysAreaDto getAreaById (Long areaId);

	/**
	 *
	 * 查询指定pid的下级行政区划
	 *
	 * @author liaoly
	 * @date 2021年9月16日 下午4:20:10
	 * @param pid
	 * @return List<SysArea>
	 */
	List<SysAreaDto> getAreaList(Long pid);

	/**
	 *
	 * 查询指定pid的下级行政区划
	 *
	 * @author liaoly
	 * @date 2021年9月17日 下午5:36:40
	 * @param pid : pid
	 * @return List<SysAreaTreeDto>
	 */
	List<SysAreaTreeDto> getAreaTreeList(Long pid);

	/**
	 * 获取区域名称
	 * @param areaId 区域id
	 * @return 区域名称
	 */
	String getAreaNameById(Long areaId);
}
