package cn.smarthse.radiationTraining.modules.sys.provider.order.right;

import cn.smarthse.radiationTraining.modules.sys.dto.order.OrderRefundContext;
import cn.smarthse.radiationTraining.modules.sys.enums.order.OrderTypeEnum;

/**
 * 订单退款后权益回收标准api
 * 需要退款的订单 可实现此接口回收具体权益
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/4/20 15:00
 */
public interface IOrderRefundRightRecover {

    /**
     * 订单类型
     *
     * @return {@link OrderTypeEnum}
     * @author liaoly
     * @date 2022/4/20 15:02
     */
    public OrderTypeEnum getOrderType();

    /**
     * 订单权益恢复
     *
     * @param orderRefundContext {@link OrderRefundContext}
     * @return {@link Boolean} 是否恢复成功 true 成功 false 失败
     * @author liaoly
     * @date 2022/4/20 15:02
     */
    public boolean recoverOrderRefundRight(OrderRefundContext orderRefundContext);
}
