
package cn.smarthse.radiationTraining.modules.sys.provider.order;

import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrderRefund;
import cn.smarthse.radiationTraining.modules.sys.param.order.OrderRefundParam;
import cn.smarthse.radiationTraining.modules.sys.vo.order.SysOrderRefundVo;

import java.util.List;

/**
 * 
 * 订单退款记录service
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午1:35:51
 */
public interface ISysOrderRefundProviderService {
	
	/**
	 * 保存下退款失败的状态和原因
	 * 
	 * @author liaoly
	 * @date 2021年8月19日 下午1:25:12
	 * @param sysOrderRefundId : 退款记录id
	 * @param failReason : 退款失败原因
	 *  void
	 */
	void saveFailOrderRefund(OrderRefundParam refundParam);

	/**
	 * 更新成功退款记录
	 *
	 * @author liaoly
	 * @date 2021年8月19日 下午1:25:12
	 * @param orderRefundId : 退款记录id
	 *  void
	 */
	void saveSuccessOrderRefund(OrderRefundParam refundParam);


	/**
	 * 添加退款记录
	 * @param orderId 订单id
	 * @param refundReason 退款原因
	 * @param userId 用户id
	 * @author liaoly
	 * @date 2022/4/19 13:53
	 */
	SysOrderRefund applyRefund(SysOrder sysOrder, String refundReason, Long userId);

	/**
	 * 查询订单所有退款记录
	 * @param orderId 订单id
	 * @return {@link List<SysOrderRefund>}
	 * @author liaoly
	 * @date 2022/4/19 14:09
	 */
	List<SysOrderRefund> getOrderRefundList(Long orderId);

	/**
	 * 查询订单所有退款记录
	 * @param orderId 订单id
	 * @return {@link List< SysOrderRefundVo >} 参数为空的话返回null
	 * @author liaoly
	 * @date 2022/4/19 14:09
	 */
	List<SysOrderRefundVo> getOrderRefundVoList(Long orderId);

	/**
	 * 查询订单所有退款记录
	 * @param orderId 订单id
	 * @param userId 用户id
	 * @return {@link List<SysOrderRefundVo>} 参数为空的话返回null
	 * @author liaoly
	 * @date 2022/4/19 14:09
	 */
	List<SysOrderRefundVo> getOrderRefundVoList(Long orderId, Long userId);

	SysOrderRefund getById(Long orderRefundId);

}
