package cn.smarthse.radiationTraining.modules.sys.provider.hse;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseIndustry;

import java.util.List;

public interface IHseIndustryProviderService {

    List<HseIndustry> query(HseIndustry industry, LayuiGridParam param);

    Long getProgenyNum(String code, Integer level);

    /**
     * 根据行业code返回该行业信息
     *
     * @param code
     * @return cn.smarthse.radiationTraining.modules.sys.entity.hse.HseIndustry
     * @author ShenZQ
     * @since 2022/10/26 10:53
     */
    HseIndustry getIndustryByCode(String code);

    /**
     * 根据行业name返回该行业信息
     *
     * @param name
     * @return cn.smarthse.radiationTraining.modules.sys.entity.hse.HseIndustry
     * @author ShenZQ
     * @since 2022/12/7 14:11
     */
    HseIndustry getIndustryByName(String name);
}