package cn.smarthse.radiationTraining.modules.sys.provider.hse;

import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseBackCompany;
import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseCompany;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;

import java.util.Date;
import java.util.List;

public interface IHseCompanyProviderService {
    /**
     * @description 获取单位信息
     * @param id
     * @return cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo
     * @author chenliang
     * @date 2022/10/25 13:23:24
     */
    HseCompanyVo getInfoById(Long id);
    List<HseCompanyVo> getInfosByIds(List<Long> ids);
    /**
     * @description 获取公司信息，以老结构的方式返回回去（培训系统的公司结构）
     * @param id
     * @return cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo
     * @author chenliang
     * @date 2022/10/26 10:55:40
     */
    CompanyInfo getOldStructureInfoById(Long id);


    /**
     * @description 获取危害因素
     * @param cid
     * @return java.util.List<java.lang.String>
     * @author chenliang
     * @date 2022/10/28 09:03:07
     */
    List<String> getRiskFactorByCid(Long cid);

    /**
     * @description 获取公司行业
     * @param cid
     * @return java.util.List<java.lang.String>
     * @author chenliang
     * @date 2022/10/28 09:20:10
     */
    List<String> getIndustryCodesByCid(Long cid);

    /**
     * @description 获取公司信息，以老结构的方式返回回去（培训系统的公司结构）
     * @param id
     * @return cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo
     * @author chenliang
     * @date 2022/10/26 10:55:40
     */
    CompanyVo getOldStructureVoById(Long id);

    /**
     * 获取公司最新源头数据
     * @return {@link HseCompany}
     * @author chenliang
     * @date 2023/2/20 13:33
     */
    void updateNewestInfoFromSource(Date time);


    /**
     * @description: 批量更新（忽略逻辑删除字段）
     * @author: chenliang
     * @date: 2023/9/20 15:55
     * @param companyList
     * @return:
     */
    void saveOrUpdateNoLogic(List<HseBackCompany> companyList);

    Long getRhoSuperviseAreaId(Long hseCid);

    /**
     *  根据名称或信用代码查询浙里卫企单位信息
     *  @param keyword 关键字
     *  @param type 1-名称 2-信用代码
     */
    CompanyVo getHseCompanyByNameOrCreditCode(String keyword, Integer type);

    /**
     *  根据名称或信用代码查询放射卫生在线医院信息
     *  @param keyword 关键字
     *  @param type 1-名称 2-信用代码
     */
    CompanyVo getRhoCompanyByNameOrCreditCode(String keyword, Integer type);

}
