package cn.smarthse.radiationTraining.modules.sys.param.user;

import jakarta.validation.constraints.Email;
import lombok.Data;

import java.io.Serializable;

/**
 * 单位用户-注册参数
 *
 * @author wuxq
 * @date 2022/3/15 10:14
 */
@Data
public class RegisterCompanyUserParam implements Serializable {

    private static final long serialVersionUID = 3055226672737277076L;

    //@ApiModelProperty("用人单位id")
    private Long cid;

    //@ApiModelProperty(value = "账号", hidden = true)
    private String username;

    //@ApiModelProperty("用人单位名称")
    private String companyName;

    //@ApiModelProperty("统一社会信用代码")
    private String creditCode;

    //@ApiModelProperty("注册地址id")
    private Long areaId;

    //@ApiModelProperty("详细注册地址")
    private String addressDetail;

    //@ApiModelProperty("行业编码")
    private String industryCode;

    //@ApiModelProperty("联系电话")
    private String contactNumber;

    //@ApiModelProperty("邮箱")
    @Email
    private String email;

    //@ApiModelProperty("是否为测试账号（0否 1是）")
    private Integer isTest;
    //@ApiModelProperty("是否隐藏,只有省账号可以看(0-否；1-是)")
    private Integer superviseIsHide;

    //@ApiModelProperty("直属企业类型：0-非直属， 1-省直属，2-市属")
    private Integer belongType;

    //@ApiModelProperty("营业状态(0-关闭；1-正常；2-暂停营业)")
    private Integer businessState;

    //@ApiModelProperty("令牌Token")
    private Long token;

    //@ApiModelProperty("密码")
    private String password;

    //@ApiModelProperty("验证码")
    private String vcode;

    //@ApiModelProperty(value = "用户类型(1-个人；2-单位；3-机构；4-医院) SysUserTypeEnum", hidden = true)
    private Integer userType;

}
