package cn.smarthse.radiationTraining.modules.sys.param.sys;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @ClassName SaveAppVersionParam
 * @Description 存储编辑app版本信息
 * @Author ChenLiang
 * @ModifyDate 2022/9/22 11:02
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
public class SaveAppVersionParam extends UserEditParam {

    //@ApiModelProperty("ID(新增数据不传，)")
    private Long id;

    //@ApiModelProperty("版本(X.Y.Z)")
    private String version;
    //@ApiModelProperty("版本(X.Y.Z)的X")
    private Integer versionX;
    //@ApiModelProperty("版本(X.Y.Z)的Y")
    private Integer versionY;
    //@ApiModelProperty("版本(X.Y.Z)的Z")
    private Integer versionZ;

    //@ApiModelProperty("软件类型(0安卓1苹果)")
    private Integer type;

    //@ApiModelProperty("日志内容")
    private String content;

    //@ApiModelProperty("是否显示日志(0否1是)")
    private Integer ifShow;

    //@ApiModelProperty("0不需要更新 1可更新 2强制更新")
    private Integer updateType;

    //@ApiModelProperty("发布时间")
    private Date releaseTime;

    //@ApiModelProperty("url")
    private String url;


    public Integer getVersionX() {
        return version == null ? null : Integer.valueOf(version.split("\\.")[0]);
    }

    public Integer getVersionY() {
        return version == null ? null : Integer.valueOf(version.split("\\.")[1]);

    }

    public Integer getVersionZ() {
        return version == null ? null : Integer.valueOf(version.split("\\.")[2]);
    }
}
