package cn.smarthse.radiationTraining.modules.sys.param.order;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 添加订单-表单()
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午1:50:23
 */
@Data
public class UserAddOrderComboParam implements Serializable {

    private static final long serialVersionUID = 71562368475698116L;
    
//    @ApiModelProperty("商品id")
    private Long goodsId;

//    @ApiModelProperty("付费类型(1-线上支付; 2-线下支付；3-赠送)")
    private Integer payType;

//    @ApiModelProperty("签约日期（商务合作）")
    private LocalDate contractDate;

//    @ApiModelProperty("到期日期（商务合作）")
    private LocalDate expireDate;
    
//    @ApiModelProperty("交易金额")
    private BigDecimal payMoney;

//    @ApiModelProperty(value = "订单类型(1-会员开通、2-会员续费、3-商务合作-签约、4-商务合作-续签、5-职业健康管理员报名、6-培训资源下载)", hidden = true)
    private Integer orderType;

//    @ApiModelProperty(value = "创建类型(1-用户创建，2-后台创建)", hidden = true)
    private Integer sourceType;

//    @ApiModelProperty(value = "关联账号id", hidden = true)
    private Long userId;

//    @ApiModelProperty(value = "关联账号", hidden = true)
    private String username;

    public UserAddOrderComboParam() {
    }

    public UserAddOrderComboParam(Long goodsId, Long userId, String username, Integer payType, Integer orderType,
                         Integer sourceType, BigDecimal payMoney, LocalDate contractDate, LocalDate expireDate) {
        this.goodsId = goodsId;
        this.payType = payType;
        this.contractDate = contractDate;
        this.expireDate = expireDate;
        this.payMoney = payMoney;
        this.orderType = orderType;
        this.sourceType = sourceType;
        this.userId = userId;
        this.username = username;
    }
}
