package cn.smarthse.radiationTraining.modules.sys.param.order;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 查询订单-参数表单
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午1:50:37
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryOrderParam extends PageParam {

    private static final long serialVersionUID = 71562368475698116L;

    //	@ApiModelProperty(hidden = true)
    private Long userId;

    //	@ApiModelProperty("订单类型")
    private List<Integer> orderType;

    //	@ApiModelProperty("付费类型(1-线上支付; 2-线下支付；3-赠送) 多个用逗号隔开")
    private List<Integer> payType;

    //	@ApiModelProperty("订单创建类型or来源(1-用户创建，2-后台创建)")
    private Integer sourceType;

    //	@ApiModelProperty("订单支付状态枚举(1-未支付（待支付）；2-已支付；3-取消; 4-已退款; 5-申请退款 多个用集合")
    private List<Integer> payState;

    //	@ApiModelProperty("开票状态(0 未开票 1 已开票)")
    private Integer invoiceState;

    // @ApiModelProperty("用户名")
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String usernameKw;
}
