package cn.smarthse.radiationTraining.modules.sys.param.order;

import cn.smarthse.radiationTraining.core.framework.model.UserEditParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 订单退款参数
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/4/19 13:37
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class OrderRefundParam extends UserEditParam implements Serializable {

    private static final long serialVersionUID = 7506613955345709092L;

    /**
     * 订单退款信息id
     */
    private Long orderRefundId;

    /**
     * 订单退款审核操作类型（1-通过；3-拒绝）
     */
    private Integer auditType;

    /**
     * 订单退款备注
     */
    private String remark;
}
