package cn.smarthse.radiationTraining.modules.sys.enums.user;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *  用户来源类型(1-个人注册；2-单位导入)
 *
 * @author wuxq
 * @date 2022/3/9 10:09
 */
@AllArgsConstructor
@Getter
public enum SysUserResourceEnum {

	/**
	 * 1-个人
	 */
	USER_REGISTER(1, "个人注册"),
	/**
	 * 2-单位
	 */
	COMPANY_IMPORT(2, "单位导入"),
	/**
	 * 3-单位单点登录
	 */
	COMPANY_CAS_LOGIN(3, "单位单点登录创建"),
	/**
	 * 4-定时任务创建单位账号
	 */
	COMPANY_TASK_REG(4, "定时任务创建单位账号"),
	/**
	 * 5-证书导入创建
	 */
	CET_IMPORT(5, "证书导入创建"),
	/**
	 * 6-浙里办
	 */
	ZLB(6, "浙里办"),;

	private Integer value;

	private String name;
}
