package cn.smarthse.radiationTraining.modules.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <h1>反馈类型 枚举</h1>
 *
 * @Author chenliang
 * @Date 2022年3月23日
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum FeedbackTypeEnum {
    corp_error("企业错误信息反馈", "100000", "正确信息：“%s”"),

    corp_error_name("企业错误信息反馈（企业名）", "100001", "正确企业名：“%s”"),

    corp_error_credit_code("企业错误信息反馈（社会信用代码）", "100002", "正确企业社会信用代码：“%s”"),

    corp_error_registered_address("企业错误信息反馈（注册地址）", "100003", "正确注册地址：“%s”")
    ;

    private String name;

    private String value;

    private String content;



    FeedbackTypeEnum(String name, String value, String content) {
        this.name = name;
        this.value = value;
        this.content = content;
    }

    public static FeedbackTypeEnum getFeedbackTypeEnum(String value) {
        if (value == null) {
            return null;
        }
        for (FeedbackTypeEnum c : values()) {
            if (c.getValue().equals(value)) {
                return c;
            }
        }
        return null;
    }

    public static String getContent(String value) {
        if (value == null) {
            return null;
        }
        for (FeedbackTypeEnum c : values()) {
            if (c.getValue().equals(value) ) {
                return c.content;
            }
        }
        return null;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}