package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

/**
 * 
 * 订单类型
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午2:06:44
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OrderTypeEnum {
	/**
	 * 培训费-1
	 */
	TRAINING_CERT("证书购买", 1),
	/**
	 * 培训-个人-2
	 */
	TRAINING_PERSONAL("在线培训报名-个人", 2),
	/**
	 * 培训-单位-3
	 */
	TRAINING_UNIT("在线培训报名-单位", 3),

	/**
	 * 岗前培训-个人报名-4
	 */
	TRAINING_PRE_PERSONAL("岗前培训报名-个人", 4),
	;
	
	private String name;
	
	private Integer value;

	OrderTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (OrderTypeEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}

	public static OrderTypeEnum getOrderType(Integer value) {
		if (value == null) {
			return null;
		}
		for (OrderTypeEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c;
			}
		}
		return null;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setValue(Integer value) {
		this.value = value;
	}
}