package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 订单创建类型(来源)枚举(1-用户创建，2-后台创建)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午2:06:44
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OrderSourceTypeEnum {
	/**
	 * 用户创建-1
	 */
	BY_USER("用户创建", 1),
	/**
	 * 后台创建-2
	 */
	BY_ADMIN("后台创建", 2),
	;
	
	private String name;
	
	private Integer value;

	private OrderSourceTypeEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (OrderSourceTypeEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
			
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer value) {
		this.value = value;
	}
}