package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;

/**
 * 
 * 订单退款状态(成功-1，失败/异常-2)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午2:06:44
 */
@Getter
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OrderRefundStateEnum {
	/**
	 * 成功-1
	 */
	SUCCESS_REFUND("退款成功", 1),
	/**
	 * 申请退款-2
	 */

	APPLY_REFUND("申请退款", 2),
	/**
	 * 退款失败-3
	 */
	FAIL("退款失败", 3),
	;
	
	private String name;
	
	private Integer value;

	OrderRefundStateEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (OrderRefundStateEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setValue(Integer value) {
		this.value = value;
	}
}