package cn.smarthse.radiationTraining.modules.sys.enums.order;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 
 * 订单支付状态枚举(1-未支付（待支付）；2-已支付；3-取消（线上超时未支付后取消）); 4-已退款; 5-申请退款
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年8月2日 下午2:06:44
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum OrderPayStateEnum {
	/**
	 * 未支付（待支付）-1
	 */
	UN_PAY("待支付", 1),
	/**
	 * 已支付-2
	 */
	PAY("已支付", 2),
	/**
	 * 取消（线上超时未支付后取消）-3
	 */
	CANCEL_PAY("已取消", 3),
	/**
	 * 已退款-4
	 */
	REFUND("已退款", 4),
	/**
	 * 申请退款-5
	 */
	APPLY_REFUND("申请退款", 5),

	/**
	 * 退款失败-6
	 */
	FAIL_REFUND("退款失败", 6),
	;
	
	private String name;
	
	private Integer value;

	OrderPayStateEnum(String name, Integer value) {
		this.name = name;
		this.value = value;
	}

	public static boolean isPay(Integer value) {
		if(value == null){
			return false;
		}
		return value.equals(OrderPayStateEnum.PAY.value) || value.equals(OrderPayStateEnum.PAY.APPLY_REFUND);
	}
	
	public static String getName(Integer value) {
		if (value == null) {
			return null;
		}
		for (OrderPayStateEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
			
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public Integer getValue() {
		return value;
	}
	public void setValue(Integer value) {
		this.value = value;
	}
}