package cn.smarthse.radiationTraining.modules.sys.enums.hse;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @ClassName IdcardTypeEnum
 * @Description TODO
 * @Author ChenLiang
 * @ModifyDate 2022/10/27 14:30
 */
//中国居民身份证、外国人永久居留身份证、港澳台居民居住证、港澳居民来往内地通行证、台湾居民来往大陆通行证、护照
@AllArgsConstructor
@Getter
public enum IdcardTypeEnum {
    CHINESE_IDENTITY_CARD(0,"ID_CARD", "中国居民身份证"),
    CHINESE_GREEN_CARD(1,   "FOREIGN_PERMANENT_RESIDENT_ID_CARD", "外国人永久居留身份证"),
    HONG_KONG_MACAO_CARD(2, "GANG_AO_TAI_RESIDENCE_CART","港澳居民居住证"),
    HONG_KONG_MACAO_TO_HINTERLAND_CARD(3,"MAINLAND_TRAVEL_PERMIT_FOR_HONGKONG_AND_MACAO_RESIDENTS", "港澳居民来往内地通行证"),
    TAIWAN(4,"MAINLAND_TRAVEL_PERMIT_FOR_TAIWAN_RESIDENTS", "台湾居民来往大陆通行证"), //台湾居民来往大陆通行证
    PASSPORT(5,"PASSPORT", "护照"),
    OFFICER_CARD(6,"OFFICER_CARD", "军官证"),
    FOREIGN_PASSPORT(7,"FOREIGN_PASSPORT", "外籍人士护照"),
    DIPLOMACY_PASSPORT(8,"DIPLOMACY_PASSPORT", "外交护照"),
    OFFICIAL_PASSPORT(9,"OFFICIAL_PASSPORT", "公务护照"),
    SOLDIER_CARD(10,"SOLDIER_CARD", "士兵证"),
    OFFICER_RETIRE_CARD(11,"OFFICER_RETIRE_CARD", "军官离退休证"),
    GANG_AO_ID_CART(12,"GANG_AO_ID_CART", "港澳居民身份证"),
    UNIFIED_SOCIAL_ID(13,"UNIFIED_SOCIAL_ID", "统一社会信用代码"),
    OTHER(-1,"OTHER", "其他"),
    ;

//            "ID_CARD:身份证," +
//            "PASSPORT:护照," +
//            "OFFICER_CARD:军官证," +
//            "MAINLAND_TRAVEL_PERMIT_FOR_HONGKONG_AND_MACAO_RESIDENTS:港澳居民来往内地通行证," +
//            "MAINLAND_TRAVEL_PERMIT_FOR_TAIWAN_RESIDENTS:台湾居民来往大陆通行证," +
//            "FOREIGN_PERMANENT_RESIDENT_ID_CARD:外国人永久居留身份证," +
//            "FOREIGN_PASSPORT:外籍人士护照," +
//            "DIPLOMACY_PASSPORT:外交护照," +
//            "OFFICIAL_PASSPORT:公务护照," +
//            "SOLDIER_CARD:士兵证," +
//            "OFFICER_RETIRE_CARD:军官离退休证," +
//            "GANG_AO_TAI_RESIDENCE_CART:港澳台居民居住证," +
//            "GANG_AO_ID_CART:港澳居民身份证," +
//            "UNIFIED_SOCIAL_ID:统一社会信用代码," +
//            "OTHER:其他"
    private Integer value;

    private String code;

    private String name;

    public static boolean contain(Integer value){
        for (IdcardTypeEnum e : values()) {
            if(e.getValue().equals(value)){
                return true;
            }
        }

        return false;
    }

    public static String getName(Integer v) {
        if (v == null) {
            return null;
        }

        for (IdcardTypeEnum e : values()) {
            if (e.getValue().equals(v)) {
                return e.getName();
            }
        }
        return null;
    }

    public static Integer getValueByCode(String code) {
        if (code == null) {
            return null;
        }

        for (IdcardTypeEnum e : values()) {
            if (e.getCode().equals(code)) {
                return e.getValue();
            }
        }
        return null;
    }
}
